/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public interface SecretKeyRingProtector {
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long var1) throws PGPException;

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long var1) throws PGPException;

    public static CachingSecretKeyRingProtector defaultSecretKeyRingProtector(SecretKeyPassphraseProvider missingPassphraseCallback) {
        return new CachingSecretKeyRingProtector(new HashMap<Long, Passphrase>(), KeyRingProtectionSettings.secureDefaultSettings(), missingPassphraseCallback);
    }

    public static SecretKeyRingProtector unlockAllKeysWith(Passphrase passphrase, PGPSecretKeyRing keys) {
        ConcurrentHashMap<Long, Passphrase> map = new ConcurrentHashMap<Long, Passphrase>();
        for (PGPSecretKey secretKey : keys) {
            map.put(secretKey.getKeyID(), passphrase);
        }
        return SecretKeyRingProtector.fromPassphraseMap(map);
    }

    public static SecretKeyRingProtector unlockSingleKeyWith(Passphrase passphrase, PGPSecretKey key) {
        return PasswordBasedSecretKeyRingProtector.forKey(key, passphrase);
    }

    public static SecretKeyRingProtector unprotectedKeys() {
        return new UnprotectedKeysProtector();
    }

    public static SecretKeyRingProtector fromPassphraseMap(Map<Long, Passphrase> passphraseMap) {
        return new CachingSecretKeyRingProtector(passphraseMap, KeyRingProtectionSettings.secureDefaultSettings(), null);
    }
}

