/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.Print;
import org.pgpainless.sop.SopKeyUtil;
import org.pgpainless.util.Passphrase;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt", description={"Encrypt a message from standard input"}, exitCodeOnInvalidInput=37)
public class Encrypt
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, description={"Type of the input data. Defaults to 'binary'"}, paramLabel="{binary|text|mime}")
    Type type;
    @CommandLine.Option(names={"--with-password"}, description={"Encrypt the message with a password"}, paramLabel="PASSWORD")
    String[] withPassword = new String[0];
    @CommandLine.Option(names={"--sign-with"}, description={"Sign the output with a private key"}, paramLabel="KEY")
    File[] signWith = new File[0];
    @CommandLine.Parameters(description={"Certificates the message gets encrypted to"}, index="0..*", paramLabel="CERTS")
    File[] certs = new File[0];

    @Override
    public void run() {
        if (this.certs.length == 0 && this.withPassword.length == 0) {
            Print.err_ln("Please either provide --with-password or at least one CERT");
            System.exit(19);
        }
        EncryptionOptions encOpt = new EncryptionOptions();
        SigningOptions signOpt = new SigningOptions();
        try {
            List<PGPPublicKeyRing> encryptionKeys = SopKeyUtil.loadCertificatesFromFile(this.certs);
            for (PGPPublicKeyRing key : encryptionKeys) {
                encOpt.addRecipient(key);
            }
        }
        catch (IOException e) {
            Print.err_ln(e.getMessage());
            System.exit(1);
            return;
        }
        for (String s : this.withPassword) {
            Passphrase passphrase = Passphrase.fromPassword(s);
            encOpt.addPassphrase(passphrase);
        }
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        for (int i = 0; i < this.signWith.length; ++i) {
            try (FileInputStream fileIn = new FileInputStream(this.signWith[i]);){
                PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(fileIn);
                signOpt.addInlineSignature(protector, secretKey, Encrypt.parseType(this.type));
                continue;
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Cannot read secret key from file " + this.signWith[i].getName());
                Print.err_ln(e.getMessage());
                System.exit(1);
            }
        }
        try {
            EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream(System.out).withOptions(ProducerOptions.signAndEncrypt(encOpt, signOpt).setAsciiArmor(this.armor));
            Streams.pipeAll(System.in, encryptionStream);
            encryptionStream.close();
        }
        catch (IOException | PGPException e) {
            Print.err_ln("An error happened.");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }

    private static DocumentSignatureType parseType(Type type) {
        return type == Type.binary ? DocumentSignatureType.BINARY_DOCUMENT : DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
    }

    public static enum Type {
        binary,
        text,
        mime;

    }
}

