/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;

public class BCUtil {
    public static InputStream getPgpDecoderInputStream(@Nonnull byte[] bytes) throws IOException {
        return BCUtil.getPgpDecoderInputStream(new ByteArrayInputStream(bytes));
    }

    public static InputStream getPgpDecoderInputStream(@Nonnull InputStream inputStream) throws IOException {
        return PGPUtil.getDecoderStream(inputStream);
    }

    public static int getBitStrenght(PGPPublicKey key) {
        int bitStrength = key.getBitStrength();
        if (bitStrength == -1) {
            ASN1ObjectIdentifier oid = ((ECPublicBCPGKey)key.getPublicKeyPacket().getKey()).getCurveOID();
            if (oid.getId().equals("1.3.6.1.4.1.11591.15.1")) {
                bitStrength = 256;
            } else if (oid.getId().equals("1.3.6.1.4.1.3029.1.5.1")) {
                bitStrength = 256;
            } else {
                throw new RuntimeException("Unknown curve: " + oid.getId());
            }
        }
        return bitStrength;
    }
}

