/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.sop.SOPImpl;
import sop.ByteArrayAndResult;
import sop.DecryptionResult;
import sop.SOP;
import sop.exception.SOPGPException;

public class EncryptDecryptRoundTripTest {
    private static SOP sop;
    private static byte[] aliceKey;
    private static byte[] aliceCert;
    private static byte[] bobKey;
    private static byte[] bobCert;
    private static byte[] message;

    @BeforeAll
    public static void setup() throws IOException {
        sop = new SOPImpl();
        aliceKey = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        aliceCert = sop.extractCert().key((InputStream)new ByteArrayInputStream(aliceKey)).getBytes();
        bobKey = sop.generateKey().userId("Bob <bob@pgpainless.org>").generate().getBytes();
        bobCert = sop.extractCert().key((InputStream)new ByteArrayInputStream(bobKey)).getBytes();
    }

    @Test
    public void basicRoundTripWithKey() throws IOException, SOPGPException.CertCannotSign {
        byte[] encrypted = sop.encrypt().signWith((InputStream)new ByteArrayInputStream(aliceKey)).withCert((InputStream)new ByteArrayInputStream(aliceCert)).withCert((InputStream)new ByteArrayInputStream(bobCert)).plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        ByteArrayAndResult bytesAndResult = sop.decrypt().withKey((InputStream)new ByteArrayInputStream(bobKey)).verifyWithCert((InputStream)new ByteArrayInputStream(aliceCert)).ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes();
        byte[] decrypted = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])decrypted);
        DecryptionResult result = (DecryptionResult)bytesAndResult.getResult();
        Assertions.assertEquals((int)1, (int)result.getVerifications().size());
    }

    @Test
    public void basicRoundTripWithoutArmorUsingKey() throws IOException, SOPGPException.CertCannotSign {
        byte[] aliceKeyNoArmor = sop.generateKey().userId("Alice <alice@unarmored.org>").noArmor().generate().getBytes();
        byte[] aliceCertNoArmor = sop.extractCert().noArmor().key((InputStream)new ByteArrayInputStream(aliceKeyNoArmor)).getBytes();
        byte[] encrypted = sop.encrypt().signWith((InputStream)new ByteArrayInputStream(aliceKeyNoArmor)).withCert((InputStream)new ByteArrayInputStream(aliceCertNoArmor)).noArmor().plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        ByteArrayAndResult bytesAndResult = sop.decrypt().withKey((InputStream)new ByteArrayInputStream(aliceKeyNoArmor)).verifyWithCert((InputStream)new ByteArrayInputStream(aliceCertNoArmor)).ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes();
        byte[] decrypted = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])decrypted);
        DecryptionResult result = (DecryptionResult)bytesAndResult.getResult();
        Assertions.assertEquals((int)1, (int)result.getVerifications().size());
    }

    @Test
    public void basicRoundTripWithPassword() throws IOException {
        byte[] encrypted = sop.encrypt().withPassword("passphr4s3").plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        ByteArrayAndResult bytesAndResult = sop.decrypt().withPassword("passphr4s3").ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes();
        byte[] decrypted = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])decrypted);
        DecryptionResult result = (DecryptionResult)bytesAndResult.getResult();
        Assertions.assertEquals((int)0, (int)result.getVerifications().size());
    }

    @Test
    public void roundTripWithDecryptionPasswordContainingWhitespace() throws IOException {
        byte[] encrypted = sop.encrypt().withPassword("passphr4s3").plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        ByteArrayAndResult bytesAndResult = sop.decrypt().withPassword("passphr4s3    ").ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes();
        byte[] decrypted = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])decrypted);
        DecryptionResult result = (DecryptionResult)bytesAndResult.getResult();
        Assertions.assertEquals((int)0, (int)result.getVerifications().size());
    }

    @Test
    public void roundTripWithEncryptionPasswordContainingWhitespace() throws IOException {
        byte[] encrypted = sop.encrypt().withPassword("passphr4s3    ").plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        ByteArrayAndResult bytesAndResult = sop.decrypt().withPassword("passphr4s3    ").ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes();
        byte[] decrypted = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])decrypted);
        DecryptionResult result = (DecryptionResult)bytesAndResult.getResult();
        Assertions.assertEquals((int)0, (int)result.getVerifications().size());
    }

    @Test
    public void encrypt_decryptAndVerifyYieldsNoSignatureException() throws IOException {
        byte[] encrypted = sop.encrypt().withCert((InputStream)new ByteArrayInputStream(bobCert)).plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> sop.decrypt().withKey((InputStream)new ByteArrayInputStream(bobKey)).verifyWithCert((InputStream)new ByteArrayInputStream(aliceCert)).ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes());
    }

    @Test
    public void encrypt_decryptWithoutKeyOrPassphraseYieldsMissingArgException() throws IOException {
        byte[] encrypted = sop.encrypt().withCert((InputStream)new ByteArrayInputStream(bobCert)).plaintext((InputStream)new ByteArrayInputStream(message)).getBytes();
        Assertions.assertThrows(SOPGPException.MissingArg.class, () -> sop.decrypt().ciphertext((InputStream)new ByteArrayInputStream(encrypted)).toBytes());
    }

    @Test
    public void decrypt_withKeyWithMultipleKeysFails() {
        byte[] keys = new byte[aliceKey.length + bobKey.length];
        System.arraycopy(aliceKey, 0, keys, 0, aliceKey.length);
        System.arraycopy(bobKey, 0, keys, aliceKey.length, bobKey.length);
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.decrypt().withKey((InputStream)new ByteArrayInputStream(keys)));
    }

    @Test
    public void decrypt_withKeyWithPasswordProtectionFails() {
        String passwordProtectedKey = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 1777 B08F B9FE 25B8 E32C  E2E2 5974 2F3E DEC0 1772\nComment: Protected <protected@pgpainless.org>\n\nlIYEYSztkRYJKwYBBAHaRw8BAQdAMAcay1YOujgMVAXQsAz/QwL2PHc8EBroTQpe\nSkizmyf+CQMC03aJCFqkseNgXBlZLknishdIO2iMz5YT2ptOjDkYLenEc71LqDTZ\nabhG9vjfaMtfUvfF6qZurbvVAC0QBr/cSVREuEqDCxpbmYKeFrMz6LQkUHJvdGVj\ndGVkIDxwcm90ZWN0ZWRAcGdwYWlubGVzcy5vcmc+iHgEExYKACAFAmEs7ZECGwEF\nFgIDAQAECwkIBwUVCgkICwIeAQIZAQAKCRBZdC8+3sAXcksuAP961t8IhIHK7cG9\nO7DjNNi35rEgvtHK6yC529gCzE5cBAEAjEgCHSu9UK4SQOSCiQNPKIJ4UUTuCWm8\nbla6dtuB1QSciwRhLO2REgorBgEEAZdVAQUBAQdAqVXssfkOprxE8weHZoa7T/5f\nkbGOA/6hmzLoYfWURhEDAQgH/gkDAtN2iQhapLHjYEJJ+kwyW2SnEFhMoWKZBG94\nRV+S+rwq+ITz/CV53Qc/XcveX6x4QmoXqK6ges7dDLYog/iJ/tFAMeV//LJHpow/\nU2SA6XGIdQQYFgoAHQUCYSztkQIbDAUWAgMBAAQLCQgHBRUKCQgLAh4BAAoJEFl0\nLz7ewBdyWJkA/j8zj+6AhhAJOdlfqA2empI+eZfZQg8D1uB/QfKNh+5CAP9VYUUf\nEZMNtnSCXP6ERFy1/CJLW4eqLL19oVBJ/mvMDJyGBGEs7ZEWCSsGAQQB2kcPAQEH\nQMZgsx/zrhfULWNsjs0ZREzEwLsPRzSgh9zKn53U/zlY/gkDAtN2iQhapLHjYHe7\nhmEPgxR7lsOZJazPnBzJGP6uRs4ts6m7e4MfEF2gk0N+iaQPowkypZS98pN5rsDg\nt9Yby6+IgqSQkMZitZAxnfepOCOI1QQYFgoAfQUCYSztkQIbAgUWAgMBAAQLCQgH\nBRUKCQgLAh4BXyAEGRYKAAYFAmEs7ZEACgkQpHV13KorLUkL3gEAnNx1GARit/FL\n4OoL0dINsmTCF8hQKe2OGgNhhkN8v90A/i2RifktEqcmMW1ezSRGlmn5hx5bTWRc\n99Ts4FiwRLQJAAoJEFl0Lz7ewBdyaysA/jk61StphMpfuRsuQwznH7L7SddNcZ1k\nl1wHK5kRJXyCAP0WUgkpEcM2bpwb4sxkCDxrfk/ixc47hGa68MPWwOJkAQ==\n=MUYS\n-----END PGP PRIVATE KEY BLOCK-----";
        Assertions.assertThrows(SOPGPException.KeyIsProtected.class, () -> sop.decrypt().withKey((InputStream)new ByteArrayInputStream(passwordProtectedKey.getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void verifyWith_noDataThrowsBadData() {
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.decrypt().verifyWithCert((InputStream)new ByteArrayInputStream(new byte[0])));
    }

    static {
        message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
    }
}

