/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.exception.SOPGPException;
import sop.operation.DetachInbandSignatureAndMessage;

public class DetachInbandSignatureAndMessageImpl
implements DetachInbandSignatureAndMessage {
    private boolean armor = true;

    public DetachInbandSignatureAndMessage noArmor() {
        this.armor = false;
        return this;
    }

    public ReadyWithResult<Signatures> message(final InputStream messageInputStream) {
        return new ReadyWithResult<Signatures>(){

            public Signatures writeTo(final OutputStream messageOutputStream) throws SOPGPException.NoSignature {
                return new Signatures(){

                    public void writeTo(OutputStream signatureOutputStream) throws IOException {
                        PGPSignatureList signatures = null;
                        try {
                            signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage((InputStream)messageInputStream, (OutputStream)messageOutputStream);
                        }
                        catch (WrongConsumingMethodException e) {
                            throw new IOException(e);
                        }
                        if (DetachInbandSignatureAndMessageImpl.this.armor) {
                            ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get((OutputStream)signatureOutputStream);
                            for (PGPSignature signature : signatures) {
                                signature.encode((OutputStream)armorOut);
                            }
                            armorOut.close();
                        } else {
                            for (PGPSignature signature : signatures) {
                                signature.encode(signatureOutputStream);
                            }
                        }
                    }
                };
            }
        };
    }
}

