/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;
import sop.exception.SOPGPException;

public class ExtractCertTest {
    public static final String key = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: A8D9 9FF4 C8DD BBA6 C610  A6B7 9ACB 2195 A9BC DF5B\nComment: Alice <alice@pgpainless.org>\n\nlFgEYSzwMhYJKwYBBAHaRw8BAQdA60pbfTLh5MB1Ka5KfZqUzMhHzJHYBvXF68mW\nBMzgupIAAPsHWal9lDZzNXUE8Xnt00IUFYhOC5P73FMLGqdpsA+fQw51tBxBbGlj\nZSA8YWxpY2VAcGdwYWlubGVzcy5vcmc+iHgEExYKACAFAmEs8DICGwEFFgIDAQAE\nCwkIBwUVCgkICwIeAQIZAQAKCRCayyGVqbzfW9EWAQDQbiKUpftQsK4IXJJ1d40H\nfe7Djhm0P08Oo73GeE8vLwEA0ArOcyBbOETBBIefigVWWay6JIt57DGxR6KWQABk\nAwKcXQRhLPAyEgorBgEEAZdVAQUBAQdAa3lioBiWVujoFINa2wVNPLjf/hc1aIPK\nsbAcs83uRysDAQgHAAD/QJGlp9SjIzT9o2e+x9jyndOhyMPSmlLljW9ZtSuzmrgU\nuYh1BBgWCgAdBQJhLPAyAhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQmsshlam8\n31u3awEA0b/hCRQNrtsITuQGS1ikzonhJITpbmrg/ZVOvBn+3jYBAIC5d4Hozn1O\naBBl1ZiY3Bl2qIFYWzVR9vFOm+Va3lkEnFgEYSzwMhYJKwYBBAHaRw8BAQdAFfJi\nf64K8E2ZlBqAAxO0eG7nIlxRYlOvbN/1vP8grW8AAP0cKOpo2uFqLzTnmzJ+rpmV\ngwUW1FiHGpM/awfg+zzCgBAxiNUEGBYKAH0FAmEs8DICGwIFFgIDAQAECwkIBwUV\nCgkICwIeAV8gBBkWCgAGBQJhLPAyAAoJEOVqq3ZdDwXc3WAA/2UaO79+srF3p/f9\nscsmj7Rax8uXKw8sJPdgPMjmo404AQDor96bTeBiGOwPq0UfY4GGRmdkH8Z95PE+\nfKyEbkjFAgAKCRCayyGVqbzfWwmUAP9AtTcZZPHa/gMYr5KXI+L7VRie9iolKII7\nglyfG0/RUwEA3hTvAPRPAFG5WFNYaQprBAnAsefmdqwdDJGPfR7uGg0=\n=BVSY\n-----END PGP PRIVATE KEY BLOCK-----\n";
    public static final String cert = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: A8D9 9FF4 C8DD BBA6 C610  A6B7 9ACB 2195 A9BC DF5B\nComment: Alice <alice@pgpainless.org>\n\nmDMEYSzwMhYJKwYBBAHaRw8BAQdA60pbfTLh5MB1Ka5KfZqUzMhHzJHYBvXF68mW\nBMzgupK0HEFsaWNlIDxhbGljZUBwZ3BhaW5sZXNzLm9yZz6IeAQTFgoAIAUCYSzw\nMgIbAQUWAgMBAAQLCQgHBRUKCQgLAh4BAhkBAAoJEJrLIZWpvN9b0RYBANBuIpSl\n+1CwrghcknV3jQd97sOOGbQ/Tw6jvcZ4Ty8vAQDQCs5zIFs4RMEEh5+KBVZZrLok\ni3nsMbFHopZAAGQDArg4BGEs8DISCisGAQQBl1UBBQEBB0BreWKgGJZW6OgUg1rb\nBU08uN/+FzVog8qxsByzze5HKwMBCAeIdQQYFgoAHQUCYSzwMgIbDAUWAgMBAAQL\nCQgHBRUKCQgLAh4BAAoJEJrLIZWpvN9bt2sBANG/4QkUDa7bCE7kBktYpM6J4SSE\n6W5q4P2VTrwZ/t42AQCAuXeB6M59TmgQZdWYmNwZdqiBWFs1UfbxTpvlWt5ZBLgz\nBGEs8DIWCSsGAQQB2kcPAQEHQBXyYn+uCvBNmZQagAMTtHhu5yJcUWJTr2zf9bz/\nIK1viNUEGBYKAH0FAmEs8DICGwIFFgIDAQAECwkIBwUVCgkICwIeAV8gBBkWCgAG\nBQJhLPAyAAoJEOVqq3ZdDwXc3WAA/2UaO79+srF3p/f9scsmj7Rax8uXKw8sJPdg\nPMjmo404AQDor96bTeBiGOwPq0UfY4GGRmdkH8Z95PE+fKyEbkjFAgAKCRCayyGV\nqbzfWwmUAP9AtTcZZPHa/gMYr5KXI+L7VRie9iolKII7glyfG0/RUwEA3hTvAPRP\nAFG5WFNYaQprBAnAsefmdqwdDJGPfR7uGg0=\n=9qam\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static SOP sop;

    @BeforeAll
    public static void setup() {
        sop = new SOPImpl();
    }

    @Test
    public void basicExtractCert() throws IOException {
        Assertions.assertArrayEquals((byte[])cert.getBytes(StandardCharsets.UTF_8), (byte[])sop.extractCert().key((InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8))).getBytes());
    }

    @Test
    public void emptyKeyDataYieldsBadData() {
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.extractCert().key((InputStream)new ByteArrayInputStream(new byte[0])));
    }
}

