/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.sop.SOPImpl;
import org.pgpainless.util.ArmorUtils;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;

public class ArmorTest {
    @Test
    public void labelIsNotSupported() {
        Assertions.assertThrows(SOPGPException.UnsupportedOption.class, () -> new SOPImpl().armor().label(ArmorLabel.Sig));
    }

    @Test
    public void armor() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        byte[] data = PGPainless.generateKeyRing().modernKeyRing("Alice", null).getEncoded();
        byte[] knownGoodArmor = ArmorUtils.toAsciiArmoredString((byte[])data).getBytes(StandardCharsets.UTF_8);
        byte[] armored = new SOPImpl().armor().data(data).getBytes();
        Assertions.assertArrayEquals((byte[])knownGoodArmor, (byte[])armored);
        byte[] dearmored = new SOPImpl().dearmor().data(knownGoodArmor).getBytes();
        Assertions.assertArrayEquals((byte[])data, (byte[])dearmored);
    }
}

