/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.SOPImpl;
import sop.ByteArrayAndResult;
import sop.Signatures;
import sop.Verification;

public class DetachInbandSignatureAndMessageTest {
    @Test
    public void testDetachingOfInbandSignaturesAndMessage() throws IOException, PGPException {
        SOPImpl sop = new SOPImpl();
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKey, DocumentSignatureType.BINARY_DOCUMENT)).setCleartextSigned());
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data), (OutputStream)signingStream);
        signingStream.close();
        ByteArrayAndResult detachedMsg = sop.detachInbandSignatureAndMessage().message(out.toByteArray()).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        byte[] signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = sop.verify().cert(cert).signatures(signature).data(message);
        Assertions.assertFalse((boolean)verificationList.isEmpty());
        Assertions.assertEquals((int)1, (int)verificationList.size());
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint(secretKey).toString(), (Object)((Verification)verificationList.get(0)).getSigningCertFingerprint());
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }
}

