/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;
import sop.enums.SignAs;
import sop.exception.SOPGPException;

public class SignTest {
    private static SOP sop;
    private static byte[] key;
    private static byte[] cert;
    private static byte[] data;

    @BeforeAll
    public static void setup() throws IOException {
        sop = new SOPImpl();
        key = sop.generateKey().userId("Alice").generate().getBytes();
        cert = sop.extractCert().key(key).getBytes();
        data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
    }

    @Test
    public void signArmored() throws IOException {
        byte[] signature = sop.sign().key(key).data(data).getBytes();
        Assertions.assertTrue((boolean)new String(signature).startsWith("-----BEGIN PGP SIGNATURE-----"));
        List verifications = sop.verify().cert(cert).notAfter(new Date(new Date().getTime() + 10000L)).notBefore(new Date(new Date().getTime() - 10000L)).signatures(signature).data(data);
        Assertions.assertEquals((int)1, (int)verifications.size());
    }

    @Test
    public void signUnarmored() throws IOException {
        byte[] signature = sop.sign().key(key).noArmor().data(data).getBytes();
        Assertions.assertFalse((boolean)new String(signature).startsWith("-----BEGIN PGP SIGNATURE-----"));
        List verifications = sop.verify().cert(cert).notAfter(new Date(new Date().getTime() + 10000L)).notBefore(new Date(new Date().getTime() - 10000L)).signatures(signature).data(data);
        Assertions.assertEquals((int)1, (int)verifications.size());
    }

    @Test
    public void rejectSignatureAsTooOld() throws IOException {
        byte[] signature = sop.sign().key(key).data(data).getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> sop.verify().cert(cert).notAfter(new Date(new Date().getTime() - 10000L)).signatures(signature).data(data));
    }

    @Test
    public void rejectSignatureAsTooYoung() throws IOException {
        byte[] signature = sop.sign().key(key).data(data).getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> sop.verify().cert(cert).notBefore(new Date(new Date().getTime() + 10000L)).signatures(signature).data(data));
    }

    @Test
    public void mode() throws IOException, PGPException {
        byte[] signature = sop.sign().mode(SignAs.Text).key(key).data(data).getBytes();
        PGPSignature sig = (PGPSignature)SignatureUtils.readSignatures((byte[])signature).get(0);
        Assertions.assertEquals((int)SignatureType.CANONICAL_TEXT_DOCUMENT.getCode(), (int)sig.getSignatureType());
    }

    @Test
    public void rejectKeyRingCollection() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing key1 = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        PGPSecretKeyRing key2 = PGPainless.generateKeyRing().modernKeyRing("Bob", null);
        PGPSecretKeyRingCollection collection = new PGPSecretKeyRingCollection(Arrays.asList(key1, key2));
        byte[] keys = collection.getEncoded();
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.sign().key(keys));
    }

    @Test
    public void rejectEncryptedKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing key = PGPainless.generateKeyRing().modernKeyRing("Alice", "passphrase");
        byte[] bytes = key.getEncoded();
        Assertions.assertThrows(SOPGPException.KeyIsProtected.class, () -> sop.sign().key(bytes));
    }
}

