/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class NonEmptyList<E> {
    private final List<E> elements;

    public NonEmptyList(E element) {
        if (element == null) {
            throw new IllegalArgumentException("Singleton element cannot be null.");
        }
        this.elements = Collections.singletonList(element);
    }

    public NonEmptyList(List<E> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Underlying list cannot be empty.");
        }
        this.elements = Collections.unmodifiableList(elements);
    }

    @Nonnull
    public E get() {
        return this.elements.get(0);
    }

    @Nonnull
    public List<E> getOthers() {
        LinkedList<E> others = new LinkedList<E>(this.elements);
        others.remove(0);
        return Collections.unmodifiableList(others);
    }

    public List<E> getAll() {
        return this.elements;
    }
}

