/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

public class AlgorithmSuite {
    private static AlgorithmSuite defaultAlgorithmSuite = new AlgorithmSuite(Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128), Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224), Arrays.asList(CompressionAlgorithm.ZLIB, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP, CompressionAlgorithm.UNCOMPRESSED));
    private Set<SymmetricKeyAlgorithm> symmetricKeyAlgorithms;
    private Set<HashAlgorithm> hashAlgorithms;
    private Set<CompressionAlgorithm> compressionAlgorithms;

    public AlgorithmSuite(List<SymmetricKeyAlgorithm> symmetricKeyAlgorithms, List<HashAlgorithm> hashAlgorithms, List<CompressionAlgorithm> compressionAlgorithms) {
        this.symmetricKeyAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<SymmetricKeyAlgorithm>(symmetricKeyAlgorithms));
        this.hashAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<HashAlgorithm>(hashAlgorithms));
        this.compressionAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<CompressionAlgorithm>(compressionAlgorithms));
    }

    public void setSymmetricKeyAlgorithms(List<SymmetricKeyAlgorithm> symmetricKeyAlgorithms) {
        this.symmetricKeyAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<SymmetricKeyAlgorithm>(symmetricKeyAlgorithms));
    }

    public Set<SymmetricKeyAlgorithm> getSymmetricKeyAlgorithms() {
        return new LinkedHashSet<SymmetricKeyAlgorithm>(this.symmetricKeyAlgorithms);
    }

    public int[] getSymmetricKeyAlgorithmIds() {
        int[] array = new int[this.symmetricKeyAlgorithms.size()];
        ArrayList<SymmetricKeyAlgorithm> list = new ArrayList<SymmetricKeyAlgorithm>(this.symmetricKeyAlgorithms);
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((SymmetricKeyAlgorithm)((Object)list.get(i))).getAlgorithmId();
        }
        return array;
    }

    public void setHashAlgorithms(List<HashAlgorithm> hashAlgorithms) {
        this.hashAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<HashAlgorithm>(hashAlgorithms));
    }

    public Set<HashAlgorithm> getHashAlgorithms() {
        return new LinkedHashSet<HashAlgorithm>(this.hashAlgorithms);
    }

    public int[] getHashAlgorithmIds() {
        int[] array = new int[this.hashAlgorithms.size()];
        ArrayList<HashAlgorithm> list = new ArrayList<HashAlgorithm>(this.hashAlgorithms);
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((HashAlgorithm)((Object)list.get(i))).getAlgorithmId();
        }
        return array;
    }

    public void setCompressionAlgorithms(List<CompressionAlgorithm> compressionAlgorithms) {
        this.compressionAlgorithms = Collections.unmodifiableSet(new LinkedHashSet<CompressionAlgorithm>(compressionAlgorithms));
    }

    public Set<CompressionAlgorithm> getCompressionAlgorithms() {
        return new LinkedHashSet<CompressionAlgorithm>(this.compressionAlgorithms);
    }

    public int[] getCompressionAlgorithmIds() {
        int[] array = new int[this.compressionAlgorithms.size()];
        ArrayList<CompressionAlgorithm> list = new ArrayList<CompressionAlgorithm>(this.compressionAlgorithms);
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((CompressionAlgorithm)((Object)list.get(i))).getAlgorithmId();
        }
        return array;
    }

    public static AlgorithmSuite getDefaultAlgorithmSuite() {
        return defaultAlgorithmSuite;
    }
}

