/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.exception.KeyValidationException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public interface EncryptionBuilderInterface {
    default public ToRecipientsOrNoEncryption onOutputStream(@Nonnull OutputStream outputStream) {
        return this.onOutputStream(outputStream, OpenPgpMetadata.FileInfo.binaryStream());
    }

    default public ToRecipientsOrNoEncryption onOutputStream(@Nonnull OutputStream outputStream, boolean forYourEyesOnly) {
        return this.onOutputStream(outputStream, forYourEyesOnly ? OpenPgpMetadata.FileInfo.forYourEyesOnly() : OpenPgpMetadata.FileInfo.binaryStream());
    }

    default public ToRecipientsOrNoEncryption onOutputStream(@Nonnull OutputStream outputStream, String fileName, boolean forYourEyesOnly) {
        return this.onOutputStream(outputStream, new OpenPgpMetadata.FileInfo(forYourEyesOnly ? "_CONSOLE" : fileName, new Date(), StreamEncoding.BINARY));
    }

    public ToRecipientsOrNoEncryption onOutputStream(@Nonnull OutputStream var1, OpenPgpMetadata.FileInfo var2);

    public static interface Armor {
        public EncryptionStream asciiArmor() throws IOException, PGPException;

        public EncryptionStream noArmor() throws IOException, PGPException;
    }

    public static interface AdditionalSignWith
    extends Armor {
        public SignWith and();
    }

    public static interface SignWith {
        @Deprecated
        public AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector var1, PGPSecretKeyRing ... var2) throws KeyValidationException, PGPException;

        @Deprecated
        public AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRingCollection var2) throws KeyValidationException, PGPException;

        default public AdditionalSignWith signInlineWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey) throws PGPException, KeyValidationException {
            return this.signInlineWith(secretKeyDecryptor, signingKey, null);
        }

        default public AdditionalSignWith signInlineWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId) throws PGPException, KeyValidationException {
            return this.signInlineWith(secretKeyDecryptor, signingKey, userId, DocumentSignatureType.BINARY_DOCUMENT);
        }

        public AdditionalSignWith signInlineWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRing var2, String var3, DocumentSignatureType var4) throws KeyValidationException, PGPException;

        default public AdditionalSignWith signDetachedWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey) throws PGPException, KeyValidationException {
            return this.signDetachedWith(secretKeyDecryptor, signingKey, null);
        }

        default public AdditionalSignWith signDetachedWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId) throws PGPException, KeyValidationException {
            return this.signDetachedWith(secretKeyDecryptor, signingKey, userId, DocumentSignatureType.BINARY_DOCUMENT);
        }

        public AdditionalSignWith signDetachedWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRing var2, String var3, DocumentSignatureType var4) throws PGPException, KeyValidationException;
    }

    public static interface SignWithOrDontSign
    extends SignWith {
        public Armor doNotSign();
    }

    public static interface ToRecipientsOrSign
    extends ToRecipients,
    SignWithOrDontSign {
    }

    public static interface AdditionalRecipients {
        public ToRecipientsOrSign and();
    }

    public static interface ToRecipients {
        public AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRing var1);

        public AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRing var1, @Nonnull String var2);

        public AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRingCollection var1, @Nonnull String var2);

        public AdditionalRecipients toRecipients(@Nonnull PGPPublicKeyRingCollection var1);

        public AdditionalRecipients forPassphrase(Passphrase var1);
    }

    public static interface ToRecipientsOrNoEncryption
    extends ToRecipients {
        public EncryptionStream withOptions(ProducerOptions var1) throws PGPException, IOException;

        public SignWithOrDontSign doNotEncrypt();
    }
}

