/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.util.Passphrase;

public class EncryptionOptions {
    private final EncryptionPurpose purpose;
    private final Set<PGPKeyEncryptionMethodGenerator> encryptionMethods = new LinkedHashSet<PGPKeyEncryptionMethodGenerator>();
    private final Set<SubkeyIdentifier> encryptionKeys = new LinkedHashSet<SubkeyIdentifier>();
    private final Map<SubkeyIdentifier, KeyRingInfo> keyRingInfo = new HashMap<SubkeyIdentifier, KeyRingInfo>();
    private final Map<SubkeyIdentifier, KeyAccessor> keyViews = new HashMap<SubkeyIdentifier, KeyAccessor>();
    private final EncryptionKeySelector encryptionKeySelector = EncryptionOptions.encryptToFirstSubkey();
    private SymmetricKeyAlgorithm encryptionAlgorithmOverride = null;

    public EncryptionOptions() {
        this(EncryptionPurpose.STORAGE_AND_COMMUNICATIONS);
    }

    public EncryptionOptions(EncryptionPurpose purpose) {
        this.purpose = purpose;
    }

    public static EncryptionOptions encryptCommunications() {
        return new EncryptionOptions(EncryptionPurpose.COMMUNICATIONS);
    }

    public static EncryptionOptions encryptDataAtRest() {
        return new EncryptionOptions(EncryptionPurpose.STORAGE);
    }

    public EncryptionOptions addRecipients(PGPPublicKeyRingCollection keys) {
        for (PGPPublicKeyRing key : keys) {
            this.addRecipient(key);
        }
        return this;
    }

    public EncryptionOptions addRecipient(PGPPublicKeyRing key, String userId) {
        return this.addRecipient(key, userId, this.encryptionKeySelector);
    }

    public EncryptionOptions addRecipient(PGPPublicKeyRing key, String userId, EncryptionKeySelector encryptionKeySelectionStrategy) {
        KeyRingInfo info = new KeyRingInfo(key, new Date());
        List<PGPPublicKey> encryptionSubkeys = encryptionKeySelectionStrategy.selectEncryptionSubkeys(info.getEncryptionSubkeys(userId, this.purpose));
        if (encryptionSubkeys.isEmpty()) {
            throw new IllegalArgumentException("Key has no suitable encryption subkeys.");
        }
        for (PGPPublicKey encryptionSubkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier(key, encryptionSubkey.getKeyID());
            this.keyRingInfo.put(keyId, info);
            this.keyViews.put(keyId, new KeyAccessor.ViaUserId(info, keyId, userId));
            this.addRecipientKey(key, encryptionSubkey);
        }
        return this;
    }

    public EncryptionOptions addRecipient(PGPPublicKeyRing key) {
        return this.addRecipient(key, this.encryptionKeySelector);
    }

    public EncryptionOptions addRecipient(PGPPublicKeyRing key, EncryptionKeySelector encryptionKeySelectionStrategy) {
        KeyRingInfo info = new KeyRingInfo(key, new Date());
        List<PGPPublicKey> encryptionSubkeys = encryptionKeySelectionStrategy.selectEncryptionSubkeys(info.getEncryptionSubkeys(this.purpose));
        if (encryptionSubkeys.isEmpty()) {
            throw new IllegalArgumentException("Key has no suitable encryption subkeys.");
        }
        for (PGPPublicKey encryptionSubkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier(key, encryptionSubkey.getKeyID());
            this.keyRingInfo.put(keyId, info);
            this.keyViews.put(keyId, new KeyAccessor.ViaKeyId(info, keyId));
            this.addRecipientKey(key, encryptionSubkey);
        }
        return this;
    }

    private void addRecipientKey(PGPPublicKeyRing keyRing, PGPPublicKey key) {
        this.encryptionKeys.add(new SubkeyIdentifier(keyRing, key.getKeyID()));
        PublicKeyKeyEncryptionMethodGenerator encryptionMethod = ImplementationFactory.getInstance().getPublicKeyKeyEncryptionMethodGenerator(key);
        this.addEncryptionMethod(encryptionMethod);
    }

    public EncryptionOptions addPassphrase(Passphrase passphrase) {
        if (passphrase.isEmpty()) {
            throw new IllegalArgumentException("Passphrase must not be empty.");
        }
        PBEKeyEncryptionMethodGenerator encryptionMethod = ImplementationFactory.getInstance().getPBEKeyEncryptionMethodGenerator(passphrase);
        return this.addEncryptionMethod(encryptionMethod);
    }

    public EncryptionOptions addEncryptionMethod(PGPKeyEncryptionMethodGenerator encryptionMethod) {
        this.encryptionMethods.add(encryptionMethod);
        return this;
    }

    Set<PGPKeyEncryptionMethodGenerator> getEncryptionMethods() {
        return new HashSet<PGPKeyEncryptionMethodGenerator>(this.encryptionMethods);
    }

    Map<SubkeyIdentifier, KeyRingInfo> getKeyRingInfo() {
        return new HashMap<SubkeyIdentifier, KeyRingInfo>(this.keyRingInfo);
    }

    Set<SubkeyIdentifier> getEncryptionKeyIdentifiers() {
        return new HashSet<SubkeyIdentifier>(this.encryptionKeys);
    }

    Map<SubkeyIdentifier, KeyAccessor> getKeyViews() {
        return new HashMap<SubkeyIdentifier, KeyAccessor>(this.keyViews);
    }

    SymmetricKeyAlgorithm getEncryptionAlgorithmOverride() {
        return this.encryptionAlgorithmOverride;
    }

    public void overrideEncryptionAlgorithm(SymmetricKeyAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == SymmetricKeyAlgorithm.NULL) {
            throw new IllegalArgumentException("Plaintext encryption can only be used to denote unencrypted secret keys.");
        }
        this.encryptionAlgorithmOverride = encryptionAlgorithm;
    }

    public static EncryptionKeySelector encryptToFirstSubkey() {
        return new EncryptionKeySelector(){

            @Override
            public List<PGPPublicKey> selectEncryptionSubkeys(List<PGPPublicKey> encryptionCapableKeys) {
                return encryptionCapableKeys.isEmpty() ? Collections.emptyList() : Collections.singletonList(encryptionCapableKeys.get(0));
            }
        };
    }

    public static EncryptionKeySelector encryptToAllCapableSubkeys() {
        return new EncryptionKeySelector(){

            @Override
            public List<PGPPublicKey> selectEncryptionSubkeys(List<PGPPublicKey> encryptionCapableKeys) {
                return encryptionCapableKeys;
            }
        };
    }

    public static interface EncryptionKeySelector {
        public List<PGPPublicKey> selectEncryptionSubkeys(List<PGPPublicKey> var1);
    }
}

