/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.ArmoredOutputStreamFactory;

public final class EncryptionStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(EncryptionStream.class.getName());
    private static final Level LEVEL = Level.FINE;
    private final ProducerOptions options;
    private final EncryptionResult.Builder resultBuilder = EncryptionResult.builder();
    private boolean closed = false;
    private static final int BUFFER_SIZE = 256;
    OutputStream outermostStream;
    private ArmoredOutputStream armorOutputStream = null;
    private OutputStream publicKeyEncryptedStream = null;
    private PGPCompressedDataGenerator compressedDataGenerator;
    private BCPGOutputStream basicCompressionStream;
    private PGPLiteralDataGenerator literalDataGenerator;
    private OutputStream literalDataStream;

    EncryptionStream(@Nonnull OutputStream targetOutputStream, @Nonnull ProducerOptions options, @Nonnull OpenPgpMetadata.FileInfo fileInfo) throws IOException, PGPException {
        this.options = options;
        this.outermostStream = targetOutputStream;
        this.prepareArmor();
        this.prepareEncryption();
        this.prepareCompression();
        this.prepareOnePassSignatures();
        this.prepareLiteralDataProcessing(fileInfo);
    }

    private void prepareArmor() {
        if (!this.options.isAsciiArmor()) {
            LOGGER.log(LEVEL, "Encryption output will be binary");
            return;
        }
        LOGGER.log(LEVEL, "Wrap encryption output in ASCII armor");
        this.armorOutputStream = ArmoredOutputStreamFactory.get(this.outermostStream);
        this.outermostStream = this.armorOutputStream;
    }

    private void prepareEncryption() throws IOException, PGPException {
        EncryptionOptions encryptionOptions = this.options.getEncryptionOptions();
        if (encryptionOptions == null || encryptionOptions.getEncryptionMethods().isEmpty()) {
            this.resultBuilder.setEncryptionAlgorithm(SymmetricKeyAlgorithm.NULL);
            return;
        }
        SymmetricKeyAlgorithm encryptionAlgorithm = EncryptionBuilder.negotiateSymmetricEncryptionAlgorithm(encryptionOptions);
        this.resultBuilder.setEncryptionAlgorithm(encryptionAlgorithm);
        LOGGER.log(LEVEL, "Encrypt message using " + (Object)((Object)encryptionAlgorithm));
        PGPDataEncryptorBuilder dataEncryptorBuilder = ImplementationFactory.getInstance().getPGPDataEncryptorBuilder(encryptionAlgorithm);
        dataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
        for (PGPKeyEncryptionMethodGenerator encryptionMethod : encryptionOptions.getEncryptionMethods()) {
            encryptedDataGenerator.addMethod(encryptionMethod);
        }
        for (SubkeyIdentifier recipientSubkeyIdentifier : encryptionOptions.getEncryptionKeyIdentifiers()) {
            this.resultBuilder.addRecipient(recipientSubkeyIdentifier);
        }
        this.outermostStream = this.publicKeyEncryptedStream = encryptedDataGenerator.open(this.outermostStream, new byte[256]);
    }

    private void prepareCompression() throws IOException {
        CompressionAlgorithm compressionAlgorithm = EncryptionBuilder.negotiateCompressionAlgorithm(this.options);
        this.resultBuilder.setCompressionAlgorithm(compressionAlgorithm);
        this.compressedDataGenerator = new PGPCompressedDataGenerator(compressionAlgorithm.getAlgorithmId());
        if (compressionAlgorithm == CompressionAlgorithm.UNCOMPRESSED) {
            return;
        }
        LOGGER.log(LEVEL, "Compress using " + (Object)((Object)compressionAlgorithm));
        this.basicCompressionStream = new BCPGOutputStream(this.compressedDataGenerator.open(this.outermostStream));
        this.outermostStream = this.basicCompressionStream;
    }

    private void prepareOnePassSignatures() throws IOException, PGPException {
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier identifier : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(identifier);
            if (signingMethod.isDetached()) continue;
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            signatureGenerator.generateOnePassVersion(false).encode(this.outermostStream);
        }
    }

    private void prepareLiteralDataProcessing(@Nonnull OpenPgpMetadata.FileInfo fileInfo) throws IOException {
        this.literalDataGenerator = new PGPLiteralDataGenerator();
        this.outermostStream = this.literalDataStream = this.literalDataGenerator.open(this.outermostStream, fileInfo.getStreamFormat().getCode(), fileInfo.getFileName(), fileInfo.getModificationDate(), new byte[256]);
        this.resultBuilder.setFileInfo(fileInfo);
    }

    @Override
    public void write(int data) throws IOException {
        this.outermostStream.write(data);
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            byte asByte = (byte)(data & 0xFF);
            signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(@Nonnull byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
        this.outermostStream.write(buffer, 0, len);
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outermostStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.literalDataStream.flush();
        this.literalDataStream.close();
        this.literalDataGenerator.close();
        try {
            this.writeSignatures();
        }
        catch (PGPException e) {
            throw new IOException("Exception while writing signatures.", e);
        }
        this.compressedDataGenerator.close();
        if (this.publicKeyEncryptedStream != null) {
            this.publicKeyEncryptedStream.flush();
            this.publicKeyEncryptedStream.close();
        }
        if (this.armorOutputStream != null) {
            this.armorOutputStream.flush();
            this.armorOutputStream.close();
        }
        this.closed = true;
    }

    private void writeSignatures() throws PGPException, IOException {
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            PGPSignature signature = signatureGenerator.generate();
            if (signingMethod.isDetached()) {
                this.resultBuilder.addDetachedSignature(signingKey, signature);
                continue;
            }
            signature.encode(this.outermostStream);
        }
    }

    public EncryptionResult getResult() {
        if (!this.closed) {
            throw new IllegalStateException("EncryptionStream must be closed before accessing the Result.");
        }
        return this.resultBuilder.build();
    }
}

