/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="sign", description={"Create a detached signature on the data from standard input"}, exitCodeOnInvalidInput=37)
public class Sign
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, description={"Defaults to 'binary'. If '--as=text' and the input data is not valid UTF-8, sign fails with return code 53."}, paramLabel="{binary|text}")
    Type type;
    @CommandLine.Parameters(description={"Secret keys used for signing"}, paramLabel="KEY", arity="1..*")
    File[] secretKeyFile;

    @Override
    public void run() {
        PGPSecretKeyRing[] secretKeys = new PGPSecretKeyRing[this.secretKeyFile.length];
        for (File file : this.secretKeyFile) {
            try {
                PGPSecretKeyRing secretKey;
                secretKeys[i] = secretKey = PGPainless.readKeyRing().secretKeyRing(new FileInputStream(file));
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Error reading secret key ring " + file.getName());
                Print.err_ln(e.getMessage());
                System.exit(1);
                return;
            }
        }
        try {
            SigningOptions signOpt = new SigningOptions();
            for (PGPSecretKeyRing signingKey : secretKeys) {
                signOpt.addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), signingKey, this.type == Type.text ? DocumentSignatureType.CANONICAL_TEXT_DOCUMENT : DocumentSignatureType.BINARY_DOCUMENT);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream(out).withOptions(ProducerOptions.sign(signOpt).setAsciiArmor(this.armor));
            Streams.pipeAll(System.in, encryptionStream);
            encryptionStream.close();
            EncryptionResult result = encryptionStream.getResult();
            for (SubkeyIdentifier signingKey : result.getDetachedSignatures().keySet()) {
                for (PGPSignature signature : result.getDetachedSignatures().get(signingKey)) {
                    Print.print_ln(Print.toString(signature.getEncoded(), this.armor));
                }
            }
        }
        catch (IOException | PGPException e) {
            Print.err_ln("Error signing data.");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }

    public static enum Type {
        binary,
        text;

    }
}

