/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.util.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.HasAnyKeyFlagSelectionStrategy;

public class EncryptionKeySelectionStrategy
extends PublicKeySelectionStrategy {
    public static final Logger LOGGER = Logger.getLogger(EncryptionKeySelectionStrategy.class.getName());
    private final HasAnyKeyFlagSelectionStrategy.PublicKey keyFlagSelector;

    public EncryptionKeySelectionStrategy(KeyFlag ... flags) {
        this.keyFlagSelector = new HasAnyKeyFlagSelectionStrategy.PublicKey(flags);
    }

    @Override
    public boolean accept(@Nonnull PGPPublicKey key) {
        if (!key.isEncryptionKey()) {
            LOGGER.log(Level.FINE, "Rejecting key " + Long.toHexString(key.getKeyID()) + " as its algorithm (" + (Object)((Object)PublicKeyAlgorithm.fromId(key.getAlgorithm())) + ") is not suitable of encryption.");
            return false;
        }
        if (!this.keyFlagSelector.accept(key)) {
            LOGGER.log(Level.FINE, "Rejecting key " + Long.toHexString(key.getKeyID()) + " as it does not the appropriate encryption key flags.");
            return false;
        }
        return true;
    }
}

