/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.util.selection.key.SecretKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.HasAnyKeyFlagSelectionStrategy;

public class SignatureKeySelectionStrategy
extends SecretKeySelectionStrategy {
    private static final Logger LOGGER = Logger.getLogger(SignatureKeySelectionStrategy.class.getName());
    HasAnyKeyFlagSelectionStrategy.SecretKey flagSelector = new HasAnyKeyFlagSelectionStrategy.SecretKey(KeyFlag.SIGN_DATA);

    @Override
    public boolean accept(@Nonnull PGPSecretKey key) {
        boolean hasSignDataKeyFlag = this.flagSelector.accept(key);
        if (!key.isSigningKey()) {
            LOGGER.log(Level.FINE, "Rejecting key " + Long.toHexString(key.getKeyID()) + " as its algorithm (" + (Object)((Object)PublicKeyAlgorithm.fromId(key.getPublicKey().getAlgorithm())) + ") is not capable of signing.");
            return false;
        }
        if (!hasSignDataKeyFlag) {
            LOGGER.log(Level.FINE, "Rejecting key " + Long.toHexString(key.getKeyID()) + " as it does not carry the key flag SIGN_DATA.");
            return false;
        }
        return true;
    }
}

