/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.sop.PGPainlessCLI;
import org.pgpainless.sop.TestUtils;
import picocli.CommandLine;

public class GenerateCertTest {
    private static File tempDir;

    @BeforeAll
    public static void setup() throws IOException {
        tempDir = TestUtils.createTempDirectory();
    }

    @Test
    public void testKeyGeneration() throws IOException, PGPException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        new CommandLine((Object)new PGPainlessCLI()).execute(new String[]{"generate-key", "--armor", "Juliet Capulet <juliet@capulet.lit>"});
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(out.toByteArray());
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid("Juliet Capulet <juliet@capulet.lit>"));
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertArrayEquals((byte[])outBegin, (byte[])TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES);
    }

    @Test
    public void testNoArmor() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        new CommandLine((Object)new PGPainlessCLI()).execute(new String[]{"generate-key", "--no-armor", "Test <test@test.test>"});
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertFalse((boolean)Arrays.equals(outBegin, TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES));
    }
}

