/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.HashMap;
import java.util.Map;

public enum HashAlgorithm {
    MD5(1, "MD5"),
    SHA1(2, "SHA1"),
    RIPEMD160(3, "RIPEMD160"),
    SHA256(8, "SHA256"),
    SHA384(9, "SHA384"),
    SHA512(10, "SHA512"),
    SHA224(11, "SHA224");

    private static final Map<Integer, HashAlgorithm> ID_MAP;
    private static final Map<String, HashAlgorithm> NAME_MAP;
    private final int algorithmId;
    private final String name;

    public static HashAlgorithm fromId(int id) {
        return ID_MAP.get(id);
    }

    public static HashAlgorithm fromName(String name) {
        return NAME_MAP.get(name);
    }

    private HashAlgorithm(int id, String name) {
        this.algorithmId = id;
        this.name = name;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public String getAlgorithmName() {
        return this.name;
    }

    static {
        ID_MAP = new HashMap<Integer, HashAlgorithm>();
        NAME_MAP = new HashMap<String, HashAlgorithm>();
        for (HashAlgorithm h : HashAlgorithm.values()) {
            ID_MAP.put(h.algorithmId, h);
            NAME_MAP.put(h.name, h);
        }
    }
}

