/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm.negotiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.policy.Policy;

public interface SymmetricKeyAlgorithmNegotiator {
    public SymmetricKeyAlgorithm negotiate(Policy.SymmetricKeyAlgorithmPolicy var1, SymmetricKeyAlgorithm var2, List<Set<SymmetricKeyAlgorithm>> var3);

    public static SymmetricKeyAlgorithmNegotiator byPopularity() {
        return new SymmetricKeyAlgorithmNegotiator(){

            @Override
            public SymmetricKeyAlgorithm negotiate(Policy.SymmetricKeyAlgorithmPolicy policy, SymmetricKeyAlgorithm override, List<Set<SymmetricKeyAlgorithm>> preferences) {
                if (override == SymmetricKeyAlgorithm.NULL) {
                    throw new IllegalArgumentException("Algorithm override cannot be NULL (plaintext).");
                }
                if (override != null) {
                    return override;
                }
                final LinkedHashMap<SymmetricKeyAlgorithm, Integer> supportWeight = new LinkedHashMap<SymmetricKeyAlgorithm, Integer>();
                for (Set<SymmetricKeyAlgorithm> keyPreferences : preferences) {
                    for (SymmetricKeyAlgorithm preferred : keyPreferences) {
                        if (supportWeight.containsKey((Object)preferred)) {
                            supportWeight.put(preferred, (Integer)supportWeight.get((Object)preferred) + 1);
                            continue;
                        }
                        supportWeight.put(preferred, 1);
                    }
                }
                ArrayList scoreboard = new ArrayList(supportWeight.keySet());
                Collections.sort(scoreboard, new Comparator<SymmetricKeyAlgorithm>(){

                    @Override
                    public int compare(SymmetricKeyAlgorithm t0, SymmetricKeyAlgorithm t1) {
                        return -((Integer)supportWeight.get((Object)t0)).compareTo((Integer)supportWeight.get((Object)t1));
                    }
                });
                for (SymmetricKeyAlgorithm mostWanted : scoreboard) {
                    if (!policy.isAcceptable(mostWanted)) continue;
                    return mostWanted;
                }
                return policy.getDefaultSymmetricKeyAlgorithm();
            }
        };
    }
}

