/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.Passphrase;

public interface DecryptionBuilderInterface {
    public DecryptWith onInputStream(@Nonnull InputStream var1);

    @Deprecated
    public static interface Build {
        @Deprecated
        public DecryptionStream build() throws IOException, PGPException;
    }

    @Deprecated
    public static interface HandleMissingPublicKeys {
        @Deprecated
        public Build handleMissingPublicKeysWith(@Nonnull MissingPublicKeyCallback var1);

        @Deprecated
        public Build ignoreMissingPublicKeys();
    }

    @Deprecated
    public static interface VerifyWith {
        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection var1);

        @Deprecated
        default public HandleMissingPublicKeys verifyWith(@Nonnull OpenPgpV4Fingerprint trustedFingerprint, @Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return this.verifyWith(Collections.singleton(trustedFingerprint), publicKeyRings);
        }

        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> var1, @Nonnull PGPPublicKeyRingCollection var2);

        @Deprecated
        default public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRing publicKeyRing) {
            return this.verifyWith(Collections.singleton(publicKeyRing));
        }

        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> var1);
    }

    @Deprecated
    public static interface Verify
    extends VerifyWith {
        @Override
        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection var1);

        @Override
        @Deprecated
        default public HandleMissingPublicKeys verifyWith(@Nonnull OpenPgpV4Fingerprint trustedFingerprint, @Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return this.verifyWith(Collections.singleton(trustedFingerprint), publicKeyRings);
        }

        @Override
        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> var1, @Nonnull PGPPublicKeyRingCollection var2);

        @Override
        @Deprecated
        default public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRing publicKeyRing) {
            return this.verifyWith(Collections.singleton(publicKeyRing));
        }

        @Override
        @Deprecated
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> var1);

        @Deprecated
        default public VerifyWith verifyDetachedSignature(@Nonnull byte[] bytes) throws IOException, PGPException {
            return this.verifyDetachedSignature(new ByteArrayInputStream(bytes));
        }

        @Deprecated
        public VerifyWith verifyDetachedSignature(@Nonnull InputStream var1) throws IOException, PGPException;

        @Deprecated
        default public VerifyWith verifyDetachedSignature(@Nonnull PGPSignature signature) {
            return this.verifyDetachedSignatures(Collections.singletonList(signature));
        }

        @Deprecated
        public VerifyWith verifyDetachedSignatures(@Nonnull List<PGPSignature> var1);

        @Deprecated
        public Build doNotVerify();
    }

    public static interface DecryptWith {
        public DecryptionStream withOptions(ConsumerOptions var1) throws PGPException, IOException;

        @Deprecated
        default public Verify decryptWith(@Nonnull PGPSecretKeyRingCollection secretKeyRings) {
            return this.decryptWith((SecretKeyRingProtector)new UnprotectedKeysProtector(), secretKeyRings);
        }

        @Deprecated
        public Verify decryptWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRingCollection var2);

        @Deprecated
        public Verify decryptWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRing var2) throws PGPException, IOException;

        @Deprecated
        public Verify decryptWith(@Nonnull Passphrase var1);

        @Deprecated
        public Verify doNotDecrypt();
    }
}

