/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.MultiMap;

public final class EncryptionResult {
    private final SymmetricKeyAlgorithm encryptionAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures;
    private final Set<SubkeyIdentifier> recipients;
    private final OpenPgpMetadata.FileInfo fileInfo;

    private EncryptionResult(SymmetricKeyAlgorithm encryptionAlgorithm, CompressionAlgorithm compressionAlgorithm, MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures, Set<SubkeyIdentifier> recipients, OpenPgpMetadata.FileInfo fileInfo) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.detachedSignatures = detachedSignatures;
        this.recipients = Collections.unmodifiableSet(recipients);
        this.fileInfo = fileInfo;
    }

    @Deprecated
    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.getEncryptionAlgorithm();
    }

    public SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public MultiMap<SubkeyIdentifier, PGPSignature> getDetachedSignatures() {
        return this.detachedSignatures;
    }

    public Set<SubkeyIdentifier> getRecipients() {
        return this.recipients;
    }

    public OpenPgpMetadata.FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SymmetricKeyAlgorithm encryptionAlgorithm;
        private CompressionAlgorithm compressionAlgorithm;
        private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures = new MultiMap();
        private Set<SubkeyIdentifier> recipients = new HashSet<SubkeyIdentifier>();
        private OpenPgpMetadata.FileInfo fileInfo;

        public Builder setEncryptionAlgorithm(SymmetricKeyAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public Builder addRecipient(SubkeyIdentifier recipient) {
            this.recipients.add(recipient);
            return this;
        }

        public Builder addDetachedSignature(SubkeyIdentifier signingSubkeyIdentifier, PGPSignature detachedSignature) {
            this.detachedSignatures.put(signingSubkeyIdentifier, detachedSignature);
            return this;
        }

        public Builder setFileInfo(OpenPgpMetadata.FileInfo fileInfo) {
            this.fileInfo = fileInfo;
            return this;
        }

        public EncryptionResult build() {
            if (this.encryptionAlgorithm == null) {
                throw new IllegalStateException("Encryption algorithm not set.");
            }
            if (this.compressionAlgorithm == null) {
                throw new IllegalStateException("Compression algorithm not set.");
            }
            if (this.fileInfo == null) {
                throw new IllegalStateException("File info not set.");
            }
            return new EncryptionResult(this.encryptionAlgorithm, this.compressionAlgorithm, this.detachedSignatures, this.recipients, this.fileInfo);
        }
    }
}

