/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.cleartext_signatures;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.Strings;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.signature.SignatureChainValidator;
import org.pgpainless.signature.cleartext_signatures.MultiPassStrategy;

public class CleartextSignatureProcessor {
    private final ArmoredInputStream in;
    private final PGPPublicKeyRingCollection verificationKeys;
    private final MultiPassStrategy multiPassStrategy;

    public CleartextSignatureProcessor(InputStream inputStream, PGPPublicKeyRingCollection verificationKeys, MultiPassStrategy multiPassStrategy) throws IOException {
        this.in = inputStream instanceof ArmoredInputStream ? (ArmoredInputStream)inputStream : new ArmoredInputStream(inputStream);
        this.verificationKeys = verificationKeys;
        this.multiPassStrategy = multiPassStrategy;
    }

    public PGPSignature process() throws IOException, PGPException {
        byte[] line;
        if (!this.in.isClearText()) {
            throw new IllegalStateException("Message is not cleartext.");
        }
        BufferedOutputStream out = new BufferedOutputStream(this.multiPassStrategy.getMessageOutputStream());
        ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
        int lookAhead = CleartextSignatureProcessor.readInputLine(lineOut, this.in);
        byte[] lineSep = CleartextSignatureProcessor.getLineSeparator();
        if (lookAhead != -1 && this.in.isClearText()) {
            line = lineOut.toByteArray();
            ((OutputStream)out).write(line, 0, CleartextSignatureProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
            ((OutputStream)out).write(lineSep);
            while (lookAhead != -1 && this.in.isClearText()) {
                lookAhead = CleartextSignatureProcessor.readInputLine(lineOut, lookAhead, this.in);
                line = lineOut.toByteArray();
                ((OutputStream)out).write(line, 0, CleartextSignatureProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                ((OutputStream)out).write(lineSep);
            }
        } else if (lookAhead != -1) {
            line = lineOut.toByteArray();
            ((OutputStream)out).write(line, 0, CleartextSignatureProcessor.getLengthWithoutSeparatorOrTrailingWhitespace(line));
            ((OutputStream)out).write(lineSep);
        }
        ((OutputStream)out).close();
        PGPObjectFactory objectFactory = new PGPObjectFactory(this.in, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        PGPSignatureList signatures = (PGPSignatureList)objectFactory.nextObject();
        PGPSignature signature = signatures.get(0);
        PGPPublicKeyRing signingKeyRing = null;
        PGPPublicKey signingKey = null;
        for (PGPPublicKeyRing ring : this.verificationKeys) {
            signingKey = ring.getPublicKey(signature.getKeyID());
            if (signingKey == null) continue;
            signingKeyRing = ring;
            break;
        }
        if (signingKey == null) {
            throw new SignatureValidationException("Missing public key " + Long.toHexString(signature.getKeyID()));
        }
        signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signingKey);
        BufferedInputStream sigIn = new BufferedInputStream(this.multiPassStrategy.getMessageInputStream());
        lookAhead = CleartextSignatureProcessor.readInputLine(lineOut, sigIn);
        CleartextSignatureProcessor.processLine(signature, lineOut.toByteArray());
        if (lookAhead != -1) {
            do {
                lookAhead = CleartextSignatureProcessor.readInputLine(lineOut, lookAhead, sigIn);
                signature.update((byte)13);
                signature.update((byte)10);
                CleartextSignatureProcessor.processLine(signature, lineOut.toByteArray());
            } while (lookAhead != -1);
        }
        ((InputStream)sigIn).close();
        SignatureChainValidator.validateSignature(signature, signingKeyRing, PGPainless.getPolicy());
        return signature;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) throws IOException {
        int ch;
        bOut.reset();
        int lookAhead = -1;
        while ((ch = fIn.read()) >= 0) {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = CleartextSignatureProcessor.readPassedEOL(bOut, ch, fIn);
            break;
        }
        return lookAhead;
    }

    private static int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) throws IOException {
        bOut.reset();
        int ch = lookAhead;
        do {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = CleartextSignatureProcessor.readPassedEOL(bOut, ch, fIn);
            break;
        } while ((ch = fIn.read()) >= 0);
        if (ch < 0) {
            lookAhead = -1;
        }
        return lookAhead;
    }

    private static int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) throws IOException {
        int lookAhead = fIn.read();
        if (lastCh == 13 && lookAhead == 10) {
            bOut.write(lookAhead);
            lookAhead = fIn.read();
        }
        return lookAhead;
    }

    private static byte[] getLineSeparator() {
        String nl = Strings.lineSeparator();
        byte[] nlBytes = new byte[nl.length()];
        for (int i = 0; i != nlBytes.length; ++i) {
            nlBytes[i] = (byte)nl.charAt(i);
        }
        return nlBytes;
    }

    private static void processLine(PGPSignature sig, byte[] line) {
        int length = CleartextSignatureProcessor.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sig.update(line, 0, length);
        }
    }

    private static void processLine(OutputStream aOut, PGPSignatureGenerator sGen, byte[] line) throws IOException {
        int length = CleartextSignatureProcessor.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sGen.update(line, 0, length);
        }
        aOut.write(line, 0, line.length);
    }

    private static int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && CleartextSignatureProcessor.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isLineEnding(byte b) {
        return b == 13 || b == 10;
    }

    private static int getLengthWithoutWhiteSpace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && CleartextSignatureProcessor.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isWhiteSpace(byte b) {
        return CleartextSignatureProcessor.isLineEnding(b) || b == 9 || b == 32;
    }
}

