/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.sop.Print;

public class SopKeyUtil {
    public static List<PGPSecretKeyRing> loadKeysFromFiles(File ... files) throws IOException, PGPException {
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        for (File file : files) {
            try (FileInputStream in = new FileInputStream(file);){
                secretKeyRings.add(PGPainless.readKeyRing().secretKeyRing(in));
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Could not load secret key " + file.getName() + ": " + e.getMessage());
                throw e;
            }
        }
        return secretKeyRings;
    }

    public static List<PGPPublicKeyRing> loadCertificatesFromFile(File ... files) throws IOException {
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        for (File file : files) {
            try (FileInputStream in = new FileInputStream(file);){
                PGPPublicKeyRingCollection collection = PGPainless.readKeyRing().keyRingCollection(in, true).getPgpPublicKeyRingCollection();
                if (collection == null) {
                    throw new PGPException("Provided file " + file.getName() + " does not contain a certificate.");
                }
                for (PGPPublicKeyRing keyRing : collection) {
                    publicKeyRings.add(keyRing);
                }
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Could not read certificate from file " + file.getName() + ": " + e.getMessage());
                throw new IOException(e);
            }
        }
        return publicKeyRings;
    }
}

