/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.Ready;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

public class ArmorImpl
implements Armor {
    public static final byte[] ARMOR_START = "-----BEGIN PGP".getBytes(Charset.forName("UTF8"));
    boolean allowNested = false;

    public Armor label(ArmorLabel label) throws SOPGPException.UnsupportedOption {
        throw new SOPGPException.UnsupportedOption();
    }

    public Armor allowNested() throws SOPGPException.UnsupportedOption {
        this.allowNested = true;
        return this;
    }

    public Ready data(final InputStream data) throws SOPGPException.BadData {
        return new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                PushbackInputStream pbIn = new PushbackInputStream(data, ARMOR_START.length);
                byte[] buffer = new byte[ARMOR_START.length];
                int read = pbIn.read(buffer);
                pbIn.unread(buffer, 0, read);
                if (!ArmorImpl.this.allowNested && Arrays.equals(ARMOR_START, buffer)) {
                    Streams.pipeAll((InputStream)pbIn, (OutputStream)System.out);
                } else {
                    ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)System.out);
                    Streams.pipeAll((InputStream)pbIn, (OutputStream)armor);
                    armor.close();
                }
            }
        };
    }
}

