/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.ArmorUtils;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.ExtractCert;

public class ExtractCertImpl
implements ExtractCert {
    private boolean armor = true;

    public ExtractCert noArmor() {
        this.armor = false;
        return this;
    }

    public Ready key(InputStream keyInputStream) throws IOException, SOPGPException.BadData {
        PGPSecretKeyRing key = PGPainless.readKeyRing().secretKeyRing(keyInputStream);
        if (key == null) {
            throw new SOPGPException.BadData((Throwable)new PGPException("No key data found."));
        }
        final PGPPublicKeyRing cert = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)key);
        return new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                OutputStream out = ExtractCertImpl.this.armor ? ArmorUtils.createArmoredOutputStreamFor((PGPKeyRing)cert, (OutputStream)outputStream) : outputStream;
                cert.encode(out);
                if (ExtractCertImpl.this.armor) {
                    out.close();
                }
            }
        };
    }
}

