/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.PGPainless;
import org.pgpainless.util.ArmorUtils;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.ExtractCert;

public class ExtractCertImpl
implements ExtractCert {
    private boolean armor = true;

    public ExtractCert noArmor() {
        this.armor = false;
        return this;
    }

    public Ready key(InputStream keyInputStream) throws IOException, SOPGPException.BadData {
        PGPSecretKeyRingCollection keys;
        try {
            keys = PGPainless.readKeyRing().secretKeyRingCollection(keyInputStream);
        }
        catch (PGPException e) {
            throw new IOException("Cannot read keys.", e);
        }
        if (keys == null || keys.size() == 0) {
            throw new SOPGPException.BadData((Throwable)new PGPException("No key data found."));
        }
        final ArrayList<PGPPublicKeyRing> certs = new ArrayList<PGPPublicKeyRing>();
        for (PGPSecretKeyRing key : keys) {
            PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)key);
            certs.add(cert);
        }
        return new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                for (PGPPublicKeyRing cert : certs) {
                    OutputStream out = ExtractCertImpl.this.armor ? ArmorUtils.createArmoredOutputStreamFor((PGPKeyRing)cert, (OutputStream)outputStream) : outputStream;
                    cert.encode(out);
                    if (!ExtractCertImpl.this.armor) continue;
                    out.close();
                }
            }
        };
    }
}

