/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.SubkeyIdentifier;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.Verify;

public class VerifyImpl
implements Verify {
    private final ConsumerOptions options = new ConsumerOptions();

    public Verify notBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotBefore(timestamp);
        return this;
    }

    public Verify notAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotAfter(timestamp);
        return this;
    }

    public Verify cert(InputStream cert) throws SOPGPException.BadData {
        PGPPublicKeyRingCollection certificates;
        try {
            certificates = PGPainless.readKeyRing().publicKeyRingCollection(cert);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        this.options.addVerificationCerts(certificates);
        return this;
    }

    public VerifyImpl signatures(InputStream signatures) throws SOPGPException.BadData {
        try {
            this.options.addVerificationOfDetachedSignatures(signatures);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    public List<Verification> data(InputStream data) throws IOException, SOPGPException.NoSignature, SOPGPException.BadData {
        try {
            DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream(data).withOptions(this.options);
            Streams.drain((InputStream)decryptionStream);
            decryptionStream.close();
            OpenPgpMetadata metadata = decryptionStream.getResult();
            ArrayList<Verification> verificationList = new ArrayList<Verification>();
            for (SubkeyIdentifier verifiedSigningKey : metadata.getVerifiedSignatures().keySet()) {
                PGPSignature signature = (PGPSignature)metadata.getVerifiedSignatures().get(verifiedSigningKey);
                verificationList.add(new Verification(signature.getCreationTime(), verifiedSigningKey.getSubkeyFingerprint().toString(), verifiedSigningKey.getPrimaryKeyFingerprint().toString()));
            }
            if (!this.options.getCertificates().isEmpty() && verificationList.isEmpty()) {
                throw new SOPGPException.NoSignature();
            }
            return verificationList;
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
    }
}

