/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

public class GenerateKeyImpl
implements GenerateKey {
    private boolean armor = true;
    private final Set<String> userIds = new LinkedHashSet<String>();
    private Passphrase passphrase;

    public GenerateKey noArmor() {
        this.armor = false;
        return this;
    }

    public GenerateKey userId(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public GenerateKey withKeyPassword(String password) {
        this.passphrase = Passphrase.fromPassword((String)password);
        return this;
    }

    public Ready generate() throws SOPGPException.MissingArg, SOPGPException.UnsupportedAsymmetricAlgo {
        Iterator<String> userIdIterator = this.userIds.iterator();
        if (!userIdIterator.hasNext()) {
            throw new SOPGPException.MissingArg("Missing user-id.");
        }
        try {
            PGPSecretKeyRing key = PGPainless.generateKeyRing().modernKeyRing(userIdIterator.next(), this.passphrase);
            if (userIdIterator.hasNext()) {
                SecretKeyRingEditorInterface editor = PGPainless.modifyKeyRing((PGPSecretKeyRing)key);
                while (userIdIterator.hasNext()) {
                    editor.addUserId((CharSequence)userIdIterator.next(), SecretKeyRingProtector.unprotectedKeys());
                }
                key = editor.done();
            }
            final PGPSecretKeyRing finalKey = key;
            return new Ready(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    if (GenerateKeyImpl.this.armor) {
                        ArmoredOutputStream armoredOutputStream = ArmorUtils.toAsciiArmoredStream((PGPKeyRing)finalKey, (OutputStream)outputStream);
                        finalKey.encode((OutputStream)armoredOutputStream);
                        armoredOutputStream.close();
                    } else {
                        finalKey.encode(outputStream);
                    }
                }
            };
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)e);
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
    }
}

