/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;

public class VersionTest {
    private static SOP sop;

    @BeforeAll
    public static void setup() {
        sop = new SOPImpl();
    }

    @Test
    public void testGetVersion() {
        String version = sop.version().getVersion();
        Assertions.assertNotNull((Object)version);
        Assertions.assertFalse((boolean)version.isEmpty());
    }

    @Test
    public void assertNameEqualsPGPainless() {
        Assertions.assertEquals((Object)"PGPainless-SOP", (Object)sop.version().getName());
    }

    @Test
    public void testGetBackendVersion() {
        String backendVersion = sop.version().getBackendVersion();
        Assertions.assertNotNull((Object)backendVersion);
        Assertions.assertFalse((boolean)backendVersion.isEmpty());
    }

    @Test
    public void testGetExtendedVersion() {
        String extendedVersion = sop.version().getExtendedVersion();
        Assertions.assertNotNull((Object)extendedVersion);
        Assertions.assertFalse((boolean)extendedVersion.isEmpty());
        String firstLine = extendedVersion.split("\n")[0];
        Assertions.assertEquals((Object)(sop.version().getName() + " " + sop.version().getVersion()), (Object)firstLine);
    }
}

