/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;
import sop.exception.SOPGPException;

public class GenerateKeyTest {
    private SOP sop;

    @BeforeEach
    public void prepare() {
        this.sop = new SOPImpl();
    }

    @Test
    public void testMissingUserId() {
        Assertions.assertThrows(SOPGPException.MissingArg.class, () -> this.sop.generateKey().generate());
    }

    @Test
    public void generateKey() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(bytes);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).isUserIdValid("Alice <alice@pgpainless.org>"));
    }

    @Test
    public void generateKeyWithMultipleUserIds() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").userId("Al <al@example.org>").generate().getBytes();
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(bytes);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)"Alice <alice@pgpainless.org>", (Object)info.getPrimaryUserId());
        Assertions.assertTrue((boolean)info.isUserIdValid("Alice <alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid("Al <al@example.org>"));
    }

    @Test
    public void unarmoredKey() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").noArmor().generate().getBytes();
        Assertions.assertFalse((boolean)new String(bytes).startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----"));
    }
}

