/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;

public class DetachedVerifyImpl
implements DetachedVerify {
    private final ConsumerOptions options = new ConsumerOptions();

    public DetachedVerify notBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotBefore(timestamp);
        return this;
    }

    public DetachedVerify notAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotAfter(timestamp);
        return this;
    }

    public DetachedVerify cert(InputStream cert) throws SOPGPException.BadData {
        PGPPublicKeyRingCollection certificates;
        try {
            certificates = PGPainless.readKeyRing().publicKeyRingCollection(cert);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        this.options.addVerificationCerts(certificates);
        return this;
    }

    public DetachedVerifyImpl signatures(InputStream signatures) throws SOPGPException.BadData {
        try {
            this.options.addVerificationOfDetachedSignatures(signatures);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    public List<Verification> data(InputStream data) throws IOException, SOPGPException.NoSignature, SOPGPException.BadData {
        try {
            DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream(data).withOptions(this.options);
            Streams.drain((InputStream)decryptionStream);
            decryptionStream.close();
            OpenPgpMetadata metadata = decryptionStream.getResult();
            ArrayList<Verification> verificationList = new ArrayList<Verification>();
            for (SignatureVerification signatureVerification : metadata.getVerifiedDetachedSignatures()) {
                verificationList.add(this.map(signatureVerification));
            }
            if (!this.options.getCertificates().isEmpty() && verificationList.isEmpty()) {
                throw new SOPGPException.NoSignature();
            }
            return verificationList;
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
    }

    private Verification map(SignatureVerification sigVerification) {
        return new Verification(sigVerification.getSignature().getCreationTime(), sigVerification.getSigningKey().getSubkeyFingerprint().toString(), sigVerification.getSigningKey().getPrimaryKeyFingerprint().toString());
    }
}

