/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;

public class DecryptImpl
implements Decrypt {
    private final ConsumerOptions consumerOptions = ConsumerOptions.get();
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();

    public DecryptImpl verifyNotBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.consumerOptions.verifyNotBefore(timestamp);
        return this;
    }

    public DecryptImpl verifyNotAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.consumerOptions.verifyNotAfter(timestamp);
        return this;
    }

    public DecryptImpl verifyWithCert(InputStream certIn) throws SOPGPException.BadData, IOException {
        try {
            PGPPublicKeyRingCollection certs = PGPainless.readKeyRing().keyRingCollection(certIn, false).getPgpPublicKeyRingCollection();
            if (certs.size() == 0) {
                throw new SOPGPException.BadData((Throwable)new PGPException("No certificates provided."));
            }
            this.consumerOptions.addVerificationCerts(certs);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        return this;
    }

    public DecryptImpl withSessionKey(SessionKey sessionKey) throws SOPGPException.UnsupportedOption {
        this.consumerOptions.setSessionKey(new org.pgpainless.util.SessionKey(SymmetricKeyAlgorithm.requireFromId((int)sessionKey.getAlgorithm()), sessionKey.getKey()));
        return this;
    }

    public DecryptImpl withPassword(String password) {
        this.consumerOptions.addDecryptionPassphrase(Passphrase.fromPassword((String)password));
        String withoutTrailingWhitespace = DecryptImpl.removeTrailingWhitespace(password);
        if (!password.equals(withoutTrailingWhitespace)) {
            this.consumerOptions.addDecryptionPassphrase(Passphrase.fromPassword((String)withoutTrailingWhitespace));
        }
        return this;
    }

    private static String removeTrailingWhitespace(String passphrase) {
        int i;
        for (i = passphrase.length() - 1; i > 0 && Character.isWhitespace(passphrase.charAt(i)); --i) {
        }
        return passphrase.substring(0, i);
    }

    public DecryptImpl withKey(InputStream keyIn) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo {
        try {
            PGPSecretKeyRingCollection secretKeyCollection = PGPainless.readKeyRing().secretKeyRingCollection(keyIn);
            for (PGPSecretKeyRing key : secretKeyCollection) {
                this.protector.addSecretKey(key);
                this.consumerOptions.addDecryptionKey(key, (SecretKeyRingProtector)this.protector);
            }
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    public Decrypt withKeyPassword(byte[] password) {
        String string = new String(password, Charset.forName("UTF8"));
        this.protector.addPassphrase(Passphrase.fromPassword((String)string));
        return this;
    }

    public ReadyWithResult<DecryptionResult> ciphertext(InputStream ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg {
        DecryptionStream decryptionStream;
        if (this.consumerOptions.getDecryptionKeys().isEmpty() && this.consumerOptions.getDecryptionPassphrases().isEmpty() && this.consumerOptions.getSessionKey() == null) {
            throw new SOPGPException.MissingArg("Missing decryption key, passphrase or session key.");
        }
        try {
            decryptionStream = PGPainless.decryptAndOrVerify().onInputStream(ciphertext).withOptions(this.consumerOptions);
        }
        catch (MissingDecryptionMethodException e) {
            throw new SOPGPException.CannotDecrypt();
        }
        catch (WrongPassphraseException e) {
            throw new SOPGPException.KeyIsProtected();
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        finally {
            this.protector.clear();
        }
        return new ReadyWithResult<DecryptionResult>(){

            public DecryptionResult writeTo(OutputStream outputStream) throws IOException, SOPGPException.NoSignature {
                Streams.pipeAll((InputStream)decryptionStream, (OutputStream)outputStream);
                decryptionStream.close();
                OpenPgpMetadata metadata = decryptionStream.getResult();
                if (!metadata.isEncrypted()) {
                    throw new SOPGPException.BadData("Data is not encrypted.");
                }
                ArrayList<Verification> verificationList = new ArrayList<Verification>();
                for (SignatureVerification signatureVerification : metadata.getVerifiedInbandSignatures()) {
                    verificationList.add(DecryptImpl.this.map(signatureVerification));
                }
                SessionKey sessionKey = null;
                if (metadata.getSessionKey() != null) {
                    org.pgpainless.util.SessionKey sk = metadata.getSessionKey();
                    sessionKey = new SessionKey((byte)sk.getAlgorithm().getAlgorithmId(), sk.getKey());
                }
                return new DecryptionResult(sessionKey, verificationList);
            }
        };
    }

    private Verification map(SignatureVerification sigVerification) {
        return new Verification(sigVerification.getSignature().getCreationTime(), sigVerification.getSigningKey().getSubkeyFingerprint().toString(), sigVerification.getSigningKey().getPrimaryKeyFingerprint().toString());
    }
}

