/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;
import sop.util.ProxyOutputStream;

public class EncryptImpl
implements Encrypt {
    EncryptionOptions encryptionOptions = EncryptionOptions.get();
    SigningOptions signingOptions = null;
    MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    private final Set<PGPSecretKeyRing> signingKeys = new HashSet<PGPSecretKeyRing>();
    private EncryptAs encryptAs = EncryptAs.Binary;
    boolean armor = true;

    public Encrypt noArmor() {
        this.armor = false;
        return this;
    }

    public Encrypt mode(EncryptAs mode) throws SOPGPException.UnsupportedOption {
        this.encryptAs = mode;
        return this;
    }

    public Encrypt signWith(InputStream keyIn) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        if (this.signingOptions == null) {
            this.signingOptions = SigningOptions.get();
        }
        try {
            PGPSecretKeyRingCollection keys = PGPainless.readKeyRing().secretKeyRingCollection(keyIn);
            if (keys.size() != 1) {
                throw new SOPGPException.BadData((Throwable)((Object)new AssertionError((Object)("Exactly one secret key at a time expected. Got " + keys.size()))));
            }
            PGPSecretKeyRing signingKey = (PGPSecretKeyRing)keys.iterator().next();
            KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)signingKey);
            if (info.getSigningSubkeys().isEmpty()) {
                throw new SOPGPException.KeyCannotSign("Key " + OpenPgpFingerprint.of((PGPKeyRing)signingKey) + " cannot sign.");
            }
            this.protector.addSecretKey(signingKey);
            this.signingKeys.add(signingKey);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    public Encrypt withKeyPassword(byte[] password) {
        String passphrase = new String(password, Charset.forName("UTF8"));
        this.protector.addPassphrase(Passphrase.fromPassword((String)passphrase));
        return this;
    }

    public Encrypt withPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        this.encryptionOptions.addPassphrase(Passphrase.fromPassword((String)password));
        return this;
    }

    public Encrypt withCert(InputStream cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        try {
            PGPPublicKeyRingCollection certificates = PGPainless.readKeyRing().keyRingCollection(cert, false).getPgpPublicKeyRingCollection();
            this.encryptionOptions.addRecipients((Iterable)certificates);
        }
        catch (KeyException.UnacceptableEncryptionKeyException e) {
            throw new SOPGPException.CertCannotEncrypt(e.getMessage(), (Throwable)e);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    public Ready plaintext(final InputStream plaintext) throws IOException {
        ProducerOptions producerOptions = this.signingOptions != null ? ProducerOptions.signAndEncrypt((EncryptionOptions)this.encryptionOptions, (SigningOptions)this.signingOptions) : ProducerOptions.encrypt((EncryptionOptions)this.encryptionOptions);
        producerOptions.setAsciiArmor(this.armor);
        producerOptions.setEncoding(EncryptImpl.encryptAsToStreamEncoding(this.encryptAs));
        for (PGPSecretKeyRing signingKey : this.signingKeys) {
            try {
                this.signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, signingKey, this.encryptAs == EncryptAs.Binary ? DocumentSignatureType.BINARY_DOCUMENT : DocumentSignatureType.CANONICAL_TEXT_DOCUMENT);
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign();
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected();
            }
            catch (PGPException e) {
                throw new SOPGPException.BadData((Throwable)e);
            }
        }
        try {
            final ProxyOutputStream proxy = new ProxyOutputStream();
            final EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)proxy).withOptions(producerOptions);
            return new Ready(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    proxy.replaceOutputStream(outputStream);
                    Streams.pipeAll((InputStream)plaintext, (OutputStream)encryptionStream);
                    encryptionStream.close();
                }
            };
        }
        catch (PGPException e) {
            throw new IOException();
        }
    }

    private static StreamEncoding encryptAsToStreamEncoding(EncryptAs encryptAs) {
        switch (encryptAs) {
            case Binary: {
                return StreamEncoding.BINARY;
            }
            case Text: {
                return StreamEncoding.UTF8;
            }
        }
        throw new IllegalArgumentException("Invalid value encountered: " + encryptAs);
    }
}

