/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import sop.ReadyWithResult;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.InlineVerify;

public class InlineVerifyImpl
implements InlineVerify {
    private final ConsumerOptions options = ConsumerOptions.get();

    public InlineVerify notBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotBefore(timestamp);
        return this;
    }

    public InlineVerify notAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.options.verifyNotAfter(timestamp);
        return this;
    }

    public InlineVerify cert(InputStream cert) throws SOPGPException.BadData {
        PGPPublicKeyRingCollection certificates;
        try {
            certificates = PGPainless.readKeyRing().publicKeyRingCollection(cert);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        this.options.addVerificationCerts(certificates);
        return this;
    }

    public ReadyWithResult<List<Verification>> data(final InputStream data) throws SOPGPException.NoSignature, SOPGPException.BadData {
        return new ReadyWithResult<List<Verification>>(){

            public List<Verification> writeTo(OutputStream outputStream) throws IOException, SOPGPException.NoSignature {
                try {
                    DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream(data).withOptions(InlineVerifyImpl.this.options);
                    Streams.pipeAll((InputStream)decryptionStream, (OutputStream)outputStream);
                    decryptionStream.close();
                    OpenPgpMetadata metadata = decryptionStream.getResult();
                    ArrayList<Verification> verificationList = new ArrayList<Verification>();
                    List verifications = metadata.isCleartextSigned() ? metadata.getVerifiedDetachedSignatures() : metadata.getVerifiedInbandSignatures();
                    for (SignatureVerification signatureVerification : verifications) {
                        verificationList.add(InlineVerifyImpl.this.map(signatureVerification));
                    }
                    if (!InlineVerifyImpl.this.options.getCertificates().isEmpty() && verificationList.isEmpty()) {
                        throw new SOPGPException.NoSignature();
                    }
                    return verificationList;
                }
                catch (PGPException | MalformedOpenPgpMessageException e) {
                    throw new SOPGPException.BadData(e);
                }
            }
        };
    }

    private Verification map(SignatureVerification sigVerification) {
        return new Verification(sigVerification.getSignature().getCreationTime(), sigVerification.getSigningKey().getSubkeyFingerprint().toString(), sigVerification.getSigningKey().getPrimaryKeyFingerprint().toString());
    }
}

