/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.sop.SOPImpl;
import sop.ByteArrayAndResult;
import sop.SOP;
import sop.enums.InlineSignAs;
import sop.operation.InlineSign;
import sop.operation.InlineVerify;

public class InlineSignVerifyRoundtripTest {
    private static final SOP sop = new SOPImpl();

    @Test
    public void testInlineSignAndVerifyWithCleartextSignatures() throws IOException {
        byte[] key = sop.generateKey().userId("Werner").withKeyPassword("sw0rdf1sh").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] message = "If you want something different, create a new protocol but don't try to\npush it onto a working system.\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)((InlineSign)sop.inlineSign().key(key)).withKeyPassword("sw0rdf1sh")).mode(InlineSignAs.clearsigned).data(message).getBytes();
        ByteArrayAndResult result = ((InlineVerify)sop.inlineVerify().cert(cert)).data(inlineSigned).toByteArrayAndResult();
        byte[] verified = result.getBytes();
        Assertions.assertFalse((boolean)((List)result.getResult()).isEmpty());
        Assertions.assertArrayEquals((byte[])message, (byte[])verified);
    }

    @Test
    public void testInlineSignAndVerifyWithBinarySignatures() throws IOException {
        byte[] key = sop.generateKey().userId("Werner").withKeyPassword("sw0rdf1sh").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] message = "Yes, this is what has been deployed worldwide for years in millions of\ninstallations (decryption wise) and is meanwhile in active use.\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)((InlineSign)sop.inlineSign().key(key)).withKeyPassword("sw0rdf1sh")).data(message).getBytes();
        ByteArrayAndResult result = ((InlineVerify)sop.inlineVerify().cert(cert)).data(inlineSigned).toByteArrayAndResult();
        byte[] verified = result.getBytes();
        Assertions.assertFalse((boolean)((List)result.getResult()).isEmpty());
        Assertions.assertArrayEquals((byte[])message, (byte[])verified);
    }
}

