/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.Ready;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

public class ArmorImpl
implements Armor {
    public Armor label(ArmorLabel label) throws SOPGPException.UnsupportedOption {
        throw new SOPGPException.UnsupportedOption("Setting custom Armor labels not supported.");
    }

    public Ready data(final InputStream data) throws SOPGPException.BadData {
        return new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                OpenPgpInputStream openPgpIn = new OpenPgpInputStream(data);
                openPgpIn.reset();
                if (openPgpIn.isAsciiArmored()) {
                    Streams.pipeAll((InputStream)openPgpIn, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.flush();
                    openPgpIn.close();
                    return;
                }
                ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bufferedOutputStream);
                Streams.pipeAll((InputStream)openPgpIn, (OutputStream)armor);
                bufferedOutputStream.flush();
                armor.close();
            }
        };
    }
}

