/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.sop.SOPImpl;
import org.pgpainless.util.ArmorUtils;
import sop.SOP;
import sop.exception.SOPGPException;

public class IncapableKeysTest {
    private static byte[] nonSigningKey;
    private static byte[] nonEncryptionKey;
    private static byte[] nonSigningCert;
    private static byte[] nonEncryptionCert;
    private static final SOP sop;

    @BeforeAll
    public static void generateKeys() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing key = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addSubkey(KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._P256), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}))).setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addUserId("Non Signing <non@signing.key>").build();
        nonSigningKey = ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)key).getBytes(StandardCharsets.UTF_8);
        nonSigningCert = sop.extractCert().key(nonSigningKey).getBytes();
        key = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addUserId("Non Encryption <non@encryption.key>").build();
        nonEncryptionKey = ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)key).getBytes(StandardCharsets.UTF_8);
        nonEncryptionCert = sop.extractCert().key(nonEncryptionKey).getBytes();
    }

    @Test
    public void encryptionToNonEncryptionKeyFails() {
        Assertions.assertThrows(SOPGPException.CertCannotEncrypt.class, () -> sop.encrypt().withCert(nonEncryptionCert));
    }

    @Test
    public void signingWithNonSigningKeyFails() {
        Assertions.assertThrows(SOPGPException.KeyCannotSign.class, () -> sop.sign().key(nonSigningKey));
        Assertions.assertThrows(SOPGPException.KeyCannotSign.class, () -> sop.detachedSign().key(nonSigningKey));
        Assertions.assertThrows(SOPGPException.KeyCannotSign.class, () -> sop.inlineSign().key(nonSigningKey));
    }

    @Test
    public void encryptAndSignWithNonSigningKeyFails() {
        Assertions.assertThrows(SOPGPException.KeyCannotSign.class, () -> sop.encrypt().signWith(nonSigningKey));
    }

    static {
        sop = new SOPImpl();
    }
}

