/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.sop.SOPImpl;
import sop.ByteArrayAndResult;
import sop.SOP;
import sop.Signatures;
import sop.enums.InlineSignAs;
import sop.enums.SignatureMode;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;
import sop.operation.InlineSign;
import sop.testsuite.assertions.VerificationListAssert;

public class InlineDetachTest {
    private static final SOP sop = new SOPImpl();

    @Test
    public void detachCleartextSignedMessage() throws IOException {
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] cleartextSigned = ((InlineSign)((InlineSign)sop.inlineSign().key(key)).withKeyPassword("sw0rdf1sh")).mode(InlineSignAs.clearsigned).data(data).getBytes();
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(cleartextSigned).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        byte[] signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().issuedBy(new OpenPgpV4Fingerprint(secretKey).toString()).hasMode(SignatureMode.text);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }

    @Test
    public void detachInbandSignedMessage() throws IOException {
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key(key)).data(data).getBytes();
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(inlineSigned).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        byte[] signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().hasMode(SignatureMode.binary);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }

    @Test
    public void detachOpenPgpMessage() throws IOException {
        Object signature;
        Object next;
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key(key)).data(data).getBytes();
        ByteArrayOutputStream literalDataAndSignatures = new ByteArrayOutputStream();
        ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)new ByteArrayInputStream(inlineSigned));
        PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory((InputStream)armorIn);
        while ((next = objectFactory.nextObject()) != null) {
            Object litGen;
            if (next instanceof PGPCompressedData) {
                PGPCompressedData compressedData = (PGPCompressedData)next;
                try {
                    objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(compressedData.getDataStream());
                    continue;
                }
                catch (PGPException e) {
                    throw new SOPGPException.BadData("Cannot decompress compressed data", (Throwable)e);
                }
            }
            if (next instanceof PGPLiteralData) {
                PGPLiteralData litDat = (PGPLiteralData)next;
                litGen = new PGPLiteralDataGenerator();
                OutputStream litOut = litGen.open((OutputStream)literalDataAndSignatures, (char)litDat.getFormat(), litDat.getFileName(), litDat.getModificationTime(), new byte[8192]);
                Streams.pipeAll((InputStream)litDat.getDataStream(), (OutputStream)litOut);
                litOut.close();
                continue;
            }
            if (!(next instanceof PGPSignatureList)) continue;
            PGPSignatureList signatures = (PGPSignatureList)next;
            litGen = signatures.iterator();
            while (litGen.hasNext()) {
                signature = (PGPSignature)litGen.next();
                signature.encode((OutputStream)literalDataAndSignatures);
            }
        }
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(literalDataAndSignatures.toByteArray()).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().hasMode(SignatureMode.binary);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }
}

