/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.exception.SOPGPException;
import sop.operation.InlineDetach;

public class InlineDetachImpl
implements InlineDetach {
    private boolean armor = true;

    public InlineDetach noArmor() {
        this.armor = false;
        return this;
    }

    public ReadyWithResult<Signatures> message(final InputStream messageInputStream) {
        return new ReadyWithResult<Signatures>(){
            private final ByteArrayOutputStream sigOut = new ByteArrayOutputStream();

            public Signatures writeTo(OutputStream messageOutputStream) throws SOPGPException.NoSignature, IOException {
                PGPSignatureList signatures = null;
                OpenPgpInputStream pgpIn = new OpenPgpInputStream(messageInputStream);
                if (pgpIn.isNonOpenPgp()) {
                    throw new SOPGPException.BadData("Data appears to be non-OpenPGP.");
                }
                if (pgpIn.isAsciiArmored()) {
                    ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)pgpIn);
                    if (armorIn.isClearText()) {
                        try {
                            signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage((InputStream)armorIn, (OutputStream)messageOutputStream);
                            if (signatures == null) {
                                throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                            }
                        }
                        catch (WrongConsumingMethodException e) {
                            throw new SOPGPException.BadData((Throwable)e);
                        }
                    }
                    pgpIn = new OpenPgpInputStream((InputStream)armorIn);
                }
                if (signatures == null) {
                    Object next;
                    if (!pgpIn.isBinaryOpenPgp()) {
                        throw new SOPGPException.BadData("Data was containing ASCII armored non-OpenPGP data.");
                    }
                    PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory((InputStream)pgpIn);
                    while ((next = objectFactory.nextObject()) != null) {
                        if (next instanceof PGPOnePassSignatureList) continue;
                        if (next instanceof PGPLiteralData) {
                            PGPLiteralData literalData = (PGPLiteralData)next;
                            InputStream literalIn = literalData.getDataStream();
                            Streams.pipeAll((InputStream)literalIn, (OutputStream)messageOutputStream);
                            literalIn.close();
                            continue;
                        }
                        if (next instanceof PGPCompressedData) {
                            PGPCompressedData compressedData = (PGPCompressedData)next;
                            try {
                                objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(compressedData.getDataStream());
                                continue;
                            }
                            catch (PGPException e) {
                                throw new SOPGPException.BadData("Cannot decompress PGPCompressedData", (Throwable)e);
                            }
                        }
                        if (!(next instanceof PGPSignatureList)) continue;
                        signatures = (PGPSignatureList)next;
                    }
                }
                if (signatures == null) {
                    throw new SOPGPException.BadData("Data did not contain OpenPGP signatures.");
                }
                if (InlineDetachImpl.this.armor) {
                    ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get((OutputStream)this.sigOut);
                    for (PGPSignature signature : signatures) {
                        signature.encode((OutputStream)armorOut);
                    }
                    armorOut.close();
                } else {
                    for (PGPSignature signature : signatures) {
                        signature.encode((OutputStream)this.sigOut);
                    }
                }
                return new Signatures(){

                    public void writeTo(OutputStream signatureOutputStream) throws IOException {
                        Streams.pipeAll((InputStream)new ByteArrayInputStream(sigOut.toByteArray()), (OutputStream)signatureOutputStream);
                    }
                };
            }
        };
    }
}

