/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class MatchMakingSecretKeyRingProtector
implements SecretKeyRingProtector {
    private final Set<Passphrase> passphrases = new HashSet<Passphrase>();
    private final Set<PGPSecretKeyRing> keys = new HashSet<PGPSecretKeyRing>();
    private final CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector();

    public void addPassphrase(Passphrase passphrase) {
        if (passphrase.isEmpty()) {
            return;
        }
        if (!this.passphrases.add(passphrase)) {
            return;
        }
        for (PGPSecretKeyRing key : this.keys) {
            for (PGPSecretKey subkey : key) {
                if (this.protector.hasPassphrase(Long.valueOf(subkey.getKeyID()))) continue;
                this.testPassphrase(passphrase, subkey);
            }
        }
    }

    public void addSecretKey(PGPSecretKeyRing key) {
        if (!this.keys.add(key)) {
            return;
        }
        for (PGPSecretKey subkey : key) {
            if (KeyInfo.isDecrypted((PGPSecretKey)subkey)) {
                this.protector.addPassphrase(Long.valueOf(subkey.getKeyID()), Passphrase.emptyPassphrase());
                continue;
            }
            for (Passphrase passphrase : this.passphrases) {
                this.testPassphrase(passphrase, subkey);
            }
        }
    }

    private void testPassphrase(Passphrase passphrase, PGPSecretKey subkey) {
        try {
            PBESecretKeyDecryptor decryptor = ImplementationFactory.getInstance().getPBESecretKeyDecryptor(passphrase);
            UnlockSecretKey.unlockSecretKey((PGPSecretKey)subkey, (PBESecretKeyDecryptor)decryptor);
            this.protector.addPassphrase(Long.valueOf(subkey.getKeyID()), passphrase);
        }
        catch (PGPException pGPException) {
            // empty catch block
        }
    }

    public boolean hasPassphraseFor(Long keyId) {
        return this.protector.hasPassphrase(keyId);
    }

    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long keyId) throws PGPException {
        return this.protector.getDecryptor(keyId);
    }

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long keyId) throws PGPException {
        return this.protector.getEncryptor(keyId);
    }

    public void clear() {
        for (Passphrase passphrase : this.passphrases) {
            passphrase.clear();
        }
        for (PGPSecretKeyRing key : this.keys) {
            this.protector.forgetPassphrase((PGPKeyRing)key);
        }
    }
}

