/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;

public class VersionTest {
    private static SOP sop;

    @BeforeAll
    public static void setup() {
        sop = new SOPImpl();
    }

    @Test
    public void testGetVersion() {
        String version = sop.version().getVersion();
        Assertions.assertNotNull((Object)version);
        Assertions.assertFalse((boolean)version.isEmpty());
    }

    @Test
    public void assertNameEqualsPGPainless() {
        Assertions.assertEquals((Object)"PGPainless-SOP", (Object)sop.version().getName());
    }

    @Test
    public void testGetBackendVersion() {
        String backendVersion = sop.version().getBackendVersion();
        Assertions.assertNotNull((Object)backendVersion);
        Assertions.assertFalse((boolean)backendVersion.isEmpty());
    }

    @Test
    public void testGetExtendedVersion() {
        String extendedVersion = sop.version().getExtendedVersion();
        Assertions.assertNotNull((Object)extendedVersion);
        Assertions.assertFalse((boolean)extendedVersion.isEmpty());
        String firstLine = extendedVersion.split("\n")[0];
        Assertions.assertEquals((Object)(sop.version().getName() + " " + sop.version().getVersion()), (Object)firstLine);
    }

    @Test
    public void testGetSopSpecVersion() {
        boolean incomplete = sop.version().isSopSpecImplementationIncomplete();
        int revisionNumber = sop.version().getSopSpecRevisionNumber();
        String revisionString = sop.version().getSopSpecRevisionName();
        Assertions.assertEquals((Object)("draft-dkg-openpgp-stateless-cli-" + String.format("%02d", revisionNumber)), (Object)revisionString);
        String incompletenessRemarks = sop.version().getSopSpecImplementationRemarks();
        String fullSopSpecVersion = sop.version().getSopSpecVersion();
        if (incomplete) {
            Assertions.assertTrue((boolean)fullSopSpecVersion.startsWith("~" + revisionString));
        } else {
            Assertions.assertTrue((boolean)fullSopSpecVersion.startsWith(revisionString));
        }
        if (incompletenessRemarks != null) {
            Assertions.assertTrue((boolean)fullSopSpecVersion.endsWith(incompletenessRemarks));
        }
    }

    @Test
    public void testGetSopVVersion() {
        String sopVVersion = sop.version().getSopVVersion();
        Assertions.assertNotNull((Object)sopVVersion);
        Assertions.assertTrue((boolean)sopVVersion.matches("\\d+\\.\\d+(\\.\\d+)*"));
    }
}

