/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.VerificationHelper;
import org.pgpainless.util.Passphrase;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/sop/DecryptImpl;", "Lsop/operation/Decrypt;", "()V", "consumerOptions", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "ciphertext", "Lsop/ReadyWithResult;", "Lsop/DecryptionResult;", "Ljava/io/InputStream;", "mapSessionKey", "Lorg/pgpainless/util/SessionKey;", "sessionKey", "Lsop/SessionKey;", "verifyNotAfter", "timestamp", "Ljava/util/Date;", "verifyNotBefore", "verifyWithCert", "cert", "withKey", "key", "withKeyPassword", "password", "", "withPassword", "", "withSessionKey", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nDecryptImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptImpl.kt\norg/pgpainless/sop/DecryptImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1855#3,2:128\n*S KotlinDebug\n*F\n+ 1 DecryptImpl.kt\norg/pgpainless/sop/DecryptImpl\n*L\n99#1:128,2\n*E\n"})
public final class DecryptImpl
implements Decrypt {
    @NotNull
    private final ConsumerOptions consumerOptions = ConsumerOptions.Companion.get();
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ReadyWithResult<DecryptionResult> ciphertext(@NotNull InputStream ciphertext2) {
        DecryptionStream decryptionStream;
        Intrinsics.checkNotNullParameter((Object)ciphertext2, (String)"ciphertext");
        if (this.consumerOptions.getDecryptionKeys().isEmpty() && this.consumerOptions.getDecryptionPassphrases().isEmpty() && this.consumerOptions.getSessionKey() == null) {
            throw new SOPGPException.MissingArg("Missing decryption key, passphrase or session key.");
        }
        try {
            decryptionStream = PGPainless.Companion.decryptAndOrVerify().onInputStream(ciphertext2).withOptions(this.consumerOptions);
        }
        catch (MissingDecryptionMethodException e) {
            throw new SOPGPException.CannotDecrypt("No usable decryption key or password provided.", (Throwable)e);
        }
        catch (WrongPassphraseException e) {
            throw new SOPGPException.KeyIsProtected();
        }
        catch (MalformedOpenPgpMessageException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        finally {
            this.protector.clear();
        }
        DecryptionStream decryptionStream2 = decryptionStream;
        return (ReadyWithResult)new ReadyWithResult<DecryptionResult>(decryptionStream2){
            final /* synthetic */ DecryptionStream $decryptionStream;
            {
                this.$decryptionStream = $decryptionStream;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public DecryptionResult writeTo(@NotNull OutputStream outputStream) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                Streams.pipeAll((InputStream)((InputStream)this.$decryptionStream), (OutputStream)outputStream);
                this.$decryptionStream.close();
                MessageMetadata metadata = this.$decryptionStream.getMetadata();
                if (!metadata.isEncrypted()) {
                    throw new SOPGPException.BadData("Data is not encrypted.");
                }
                Iterable $this$map$iv = metadata.getVerifiedInlineSignatures();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SignatureVerification signatureVerification = (SignatureVerification)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(VerificationHelper.Companion.mapVerification((SignatureVerification)it));
                }
                List verificationList = (List)destination$iv$iv;
                SessionKey sessionKey = null;
                if (metadata.getSessionKey() != null) {
                    org.pgpainless.util.SessionKey sessionKey2 = metadata.getSessionKey();
                    Intrinsics.checkNotNull((Object)sessionKey2);
                    byte by = (byte)sessionKey2.getAlgorithm().getAlgorithmId();
                    org.pgpainless.util.SessionKey sessionKey3 = metadata.getSessionKey();
                    Intrinsics.checkNotNull((Object)sessionKey3);
                    sessionKey = new SessionKey(by, sessionKey3.getKey());
                }
                return new DecryptionResult(sessionKey, verificationList);
            }
        };
    }

    @NotNull
    public Decrypt verifyNotAfter(@NotNull Date timestamp) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptImpl $this$verifyNotAfter_u24lambda_u240 = decryptImpl = this;
        boolean bl = false;
        $this$verifyNotAfter_u24lambda_u240.consumerOptions.verifyNotAfter(timestamp);
        return decryptImpl;
    }

    @NotNull
    public Decrypt verifyNotBefore(@NotNull Date timestamp) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptImpl $this$verifyNotBefore_u24lambda_u241 = decryptImpl = this;
        boolean bl = false;
        $this$verifyNotBefore_u24lambda_u241.consumerOptions.verifyNotBefore(timestamp);
        return decryptImpl;
    }

    @NotNull
    public Decrypt verifyWithCert(@NotNull InputStream cert) {
        DecryptImpl decryptImpl;
        block0: {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            DecryptImpl $this$verifyWithCert_u24lambda_u243 = decryptImpl = this;
            boolean bl = false;
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection = KeyReader.Companion.readPublicKeys(cert, true);
            if (pGPPublicKeyRingCollection == null) break block0;
            PGPPublicKeyRingCollection it = pGPPublicKeyRingCollection;
            boolean bl2 = false;
            $this$verifyWithCert_u24lambda_u243.consumerOptions.addVerificationCerts(it);
        }
        return decryptImpl;
    }

    @NotNull
    public Decrypt withKey(@NotNull InputStream key2) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        DecryptImpl $this$withKey_u24lambda_u245 = decryptImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)KeyReader.Companion.readSecretKeys(key2, true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl2 = false;
            MatchMakingSecretKeyRingProtector matchMakingSecretKeyRingProtector = $this$withKey_u24lambda_u245.protector;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            matchMakingSecretKeyRingProtector.addSecretKey(it);
            $this$withKey_u24lambda_u245.consumerOptions.addDecryptionKey(it, (SecretKeyRingProtector)$this$withKey_u24lambda_u245.protector);
        }
        return decryptImpl;
    }

    @NotNull
    public Decrypt withKeyPassword(@NotNull byte[] password) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptImpl $this$withKeyPassword_u24lambda_u246 = decryptImpl = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u246.protector.addPassphrase(Passphrase.Companion.fromPassword((CharSequence)new String(password, UTF8Util.UTF8)));
        return decryptImpl;
    }

    @NotNull
    public Decrypt withPassword(@NotNull String password) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptImpl $this$withPassword_u24lambda_u248 = decryptImpl = this;
        boolean bl = false;
        $this$withPassword_u24lambda_u248.consumerOptions.addDecryptionPassphrase(Passphrase.Companion.fromPassword((CharSequence)password));
        String it = ((Object)StringsKt.trimEnd((CharSequence)password)).toString();
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)it, (Object)password)) {
            $this$withPassword_u24lambda_u248.consumerOptions.addDecryptionPassphrase(Passphrase.Companion.fromPassword((CharSequence)it));
        }
        return decryptImpl;
    }

    @NotNull
    public Decrypt withSessionKey(@NotNull SessionKey sessionKey) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        DecryptImpl $this$withSessionKey_u24lambda_u249 = decryptImpl = this;
        boolean bl = false;
        $this$withSessionKey_u24lambda_u249.consumerOptions.setSessionKey($this$withSessionKey_u24lambda_u249.mapSessionKey(sessionKey));
        return decryptImpl;
    }

    private final org.pgpainless.util.SessionKey mapSessionKey(SessionKey sessionKey) {
        return new org.pgpainless.util.SessionKey(SymmetricKeyAlgorithm.Companion.requireFromId((int)sessionKey.getAlgorithm()), sessionKey.getKey());
    }
}

