/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.EncryptionResult;
import sop.Profile;
import sop.ReadyWithResult;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/pgpainless/sop/EncryptImpl;", "Lsop/operation/Encrypt;", "()V", "armor", "", "encryptionOptions", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "mode", "Lsop/enums/EncryptAs;", "profile", "", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "signingKeys", "", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "modeToSignatureType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "modeToStreamEncoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "noArmor", "plaintext", "Lsop/ReadyWithResult;", "Lsop/EncryptionResult;", "Ljava/io/InputStream;", "profileName", "signWith", "key", "withCert", "cert", "withKeyPassword", "password", "", "withPassword", "Companion", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nEncryptImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptImpl.kt\norg/pgpainless/sop/EncryptImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1855#3,2:158\n*S KotlinDebug\n*F\n+ 1 EncryptImpl.kt\norg/pgpainless/sop/EncryptImpl\n*L\n68#1:158,2\n*E\n"})
public final class EncryptImpl
implements Encrypt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptionOptions encryptionOptions = EncryptionOptions.Companion.get();
    @Nullable
    private SigningOptions signingOptions;
    @NotNull
    private final List<PGPSecretKeyRing> signingKeys = new ArrayList();
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    @NotNull
    private String profile = RFC4880_PROFILE.getName();
    @NotNull
    private EncryptAs mode = EncryptAs.binary;
    private boolean armor = true;
    @JvmField
    @NotNull
    public static final Profile RFC4880_PROFILE = new Profile("rfc4880", "Follow the packet format of rfc4880");
    @JvmField
    @NotNull
    public static final List<Profile> SUPPORTED_PROFILES = CollectionsKt.listOf((Object)RFC4880_PROFILE);

    @NotNull
    public Encrypt mode(@NotNull EncryptAs mode) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        EncryptImpl $this$mode_u24lambda_u240 = encryptImpl = this;
        boolean bl = false;
        $this$mode_u24lambda_u240.mode = mode;
        return encryptImpl;
    }

    @NotNull
    public Encrypt noArmor() {
        EncryptImpl encryptImpl;
        EncryptImpl $this$noArmor_u24lambda_u241 = encryptImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u241.armor = false;
        return encryptImpl;
    }

    @NotNull
    public ReadyWithResult<EncryptionResult> plaintext(@NotNull InputStream plaintext2) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
        if (!this.encryptionOptions.hasEncryptionMethod()) {
            throw new SOPGPException.MissingArg("Missing encryption method.");
        }
        if (this.signingOptions != null) {
            SigningOptions signingOptions = this.signingOptions;
            Intrinsics.checkNotNull((Object)signingOptions);
            producerOptions = ProducerOptions.Companion.signAndEncrypt(this.encryptionOptions, signingOptions);
        } else {
            producerOptions = ProducerOptions.Companion.encrypt(this.encryptionOptions);
        }
        ProducerOptions options = producerOptions.setAsciiArmor(this.armor).setEncoding(this.modeToStreamEncoding(this.mode));
        Iterable $this$forEach$iv = this.signingKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            try {
                SigningOptions signingOptions = this.signingOptions;
                Intrinsics.checkNotNull((Object)signingOptions);
                signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, it, this.modeToSignatureType(this.mode));
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)it)) + " cannot sign", (Throwable)e);
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Cannot unlock key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)it)), (Throwable)e);
            }
            catch (PGPException e) {
                throw new SOPGPException.BadData((Throwable)e);
            }
        }
        try {
            return (ReadyWithResult)new ReadyWithResult<EncryptionResult>(options, plaintext2){
                final /* synthetic */ ProducerOptions $options;
                final /* synthetic */ InputStream $plaintext;
                {
                    this.$options = $options;
                    this.$plaintext = $plaintext;
                }

                @NotNull
                public EncryptionResult writeTo(@NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    EncryptionStream encryptionStream = PGPainless.Companion.encryptAndOrSign().onOutputStream(outputStream).withOptions(this.$options);
                    Streams.pipeAll((InputStream)this.$plaintext, (OutputStream)((OutputStream)encryptionStream));
                    encryptionStream.close();
                    return new EncryptionResult(null);
                }
            };
        }
        catch (PGPException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public Encrypt profile(@NotNull String profileName) {
        Object object;
        Object v0;
        EncryptImpl encryptImpl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            EncryptImpl $this$profile_u24lambda_u244 = encryptImpl = this;
            boolean bl = false;
            Iterable iterable = SUPPORTED_PROFILES;
            EncryptImpl encryptImpl2 = $this$profile_u24lambda_u244;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Profile it = (Profile)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)profileName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Profile)v0) == null || (object = object.getName()) == null) {
            throw new SOPGPException.UnsupportedProfile("encrypt", profileName);
        }
        encryptImpl2.profile = object;
        return encryptImpl;
    }

    @NotNull
    public Encrypt signWith(@NotNull InputStream key2) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        EncryptImpl $this$signWith_u24lambda_u245 = encryptImpl = this;
        boolean bl = false;
        if ($this$signWith_u24lambda_u245.signingOptions == null) {
            $this$signWith_u24lambda_u245.signingOptions = SigningOptions.Companion.get();
        }
        PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)CollectionsKt.singleOrNull((Iterable)((Iterable)KeyReader.Companion.readSecretKeys(key2, true)));
        if (pGPSecretKeyRing == null) {
            throw new SOPGPException.BadData((Throwable)((Object)new AssertionError((Object)"Exactly one secret key at a time expected. Got zero or multiple instead.")));
        }
        PGPSecretKeyRing signingKey = pGPSecretKeyRing;
        KeyRingInfo info = PGPainless.Companion.inspectKeyRing$default((PGPainless.Companion)PGPainless.Companion, (PGPKeyRing)((PGPKeyRing)signingKey), null, (int)2, null);
        if (info.getSigningSubkeys().isEmpty()) {
            throw new SOPGPException.KeyCannotSign("Key " + info.getFingerprint() + " cannot sign.");
        }
        $this$signWith_u24lambda_u245.protector.addSecretKey(signingKey);
        $this$signWith_u24lambda_u245.signingKeys.add(signingKey);
        return encryptImpl;
    }

    @NotNull
    public Encrypt withCert(@NotNull InputStream cert) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        EncryptImpl $this$withCert_u24lambda_u246 = encryptImpl = this;
        boolean bl = false;
        try {
            $this$withCert_u24lambda_u246.encryptionOptions.addRecipients((Iterable)KeyReader.Companion.readPublicKeys(cert, true));
        }
        catch (KeyException.UnacceptableEncryptionKeyException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Cert cannot encrypt";
            }
            throw new SOPGPException.CertCannotEncrypt(string, (Throwable)e);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        return encryptImpl;
    }

    @NotNull
    public Encrypt withKeyPassword(@NotNull byte[] password) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptImpl $this$withKeyPassword_u24lambda_u247 = encryptImpl = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u247.protector.addPassphrase(Passphrase.Companion.fromPassword((CharSequence)new String(password, UTF8Util.UTF8)));
        return encryptImpl;
    }

    @NotNull
    public Encrypt withPassword(@NotNull String password) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptImpl $this$withPassword_u24lambda_u248 = encryptImpl = this;
        boolean bl = false;
        $this$withPassword_u24lambda_u248.encryptionOptions.addPassphrase(Passphrase.Companion.fromPassword((CharSequence)password));
        return encryptImpl;
    }

    private final StreamEncoding modeToStreamEncoding(EncryptAs mode) {
        StreamEncoding streamEncoding;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                streamEncoding = StreamEncoding.BINARY;
                break;
            }
            case 2: {
                streamEncoding = StreamEncoding.UTF8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return streamEncoding;
    }

    private final DocumentSignatureType modeToSignatureType(EncryptAs mode) {
        DocumentSignatureType documentSignatureType;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
                break;
            }
            case 2: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return documentSignatureType;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/sop/EncryptImpl$Companion;", "", "()V", "RFC4880_PROFILE", "Lsop/Profile;", "SUPPORTED_PROFILES", "", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptAs.values().length];
            try {
                nArray[EncryptAs.binary.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptAs.text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

