/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;
import sop.enums.SignAs;
import sop.enums.SignatureMode;
import sop.exception.SOPGPException;
import sop.operation.DetachedSign;
import sop.operation.DetachedVerify;
import sop.testsuite.assertions.VerificationListAssert;

public class DetachedSignTest {
    private static SOP sop;
    private static byte[] key;
    private static byte[] cert;
    private static byte[] data;

    @BeforeAll
    public static void setup() throws IOException {
        sop = new SOPImpl();
        key = sop.generateKey().userId("Alice").generate().getBytes();
        cert = sop.extractCert().key(key).getBytes();
        data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
    }

    @Test
    public void signArmored() throws IOException {
        byte[] signature = ((DetachedSign)sop.sign().key(key)).mode(SignAs.binary).data(data).toByteArrayAndResult().getBytes();
        Assertions.assertTrue((boolean)new String(signature).startsWith("-----BEGIN PGP SIGNATURE-----"));
        List verifications = ((DetachedVerify)((DetachedVerify)((DetachedVerify)sop.verify().cert(cert)).notAfter(new Date(System.currentTimeMillis() + 10000L))).notBefore(new Date(System.currentTimeMillis() - 10000L))).signatures(signature).data(data);
        VerificationListAssert.assertThatVerificationList((List)verifications).hasSingleItem().hasMode(SignatureMode.binary);
    }

    @Test
    public void signUnarmored() throws IOException {
        byte[] signature = ((DetachedSign)((DetachedSign)sop.sign().key(key)).noArmor()).data(data).toByteArrayAndResult().getBytes();
        Assertions.assertFalse((boolean)new String(signature).startsWith("-----BEGIN PGP SIGNATURE-----"));
        List verifications = ((DetachedVerify)((DetachedVerify)((DetachedVerify)sop.verify().cert(cert)).notAfter(new Date(System.currentTimeMillis() + 10000L))).notBefore(new Date(System.currentTimeMillis() - 10000L))).signatures(signature).data(data);
        VerificationListAssert.assertThatVerificationList((List)verifications).hasSingleItem();
    }

    @Test
    public void textSig() throws IOException {
        byte[] signature = ((DetachedSign)((DetachedSign)sop.sign().key(key)).noArmor()).mode(SignAs.text).data(data).toByteArrayAndResult().getBytes();
        List verifications = ((DetachedVerify)((DetachedVerify)((DetachedVerify)sop.verify().cert(cert)).notAfter(new Date(System.currentTimeMillis() + 10000L))).notBefore(new Date(System.currentTimeMillis() - 10000L))).signatures(signature).data(data);
        VerificationListAssert.assertThatVerificationList((List)verifications).hasSingleItem().hasMode(SignatureMode.text);
    }

    @Test
    public void rejectSignatureAsTooOld() throws IOException {
        byte[] signature = ((DetachedSign)sop.sign().key(key)).data(data).toByteArrayAndResult().getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> ((DetachedVerify)((DetachedVerify)sop.verify().cert(cert)).notAfter(new Date(System.currentTimeMillis() - 10000L))).signatures(signature).data(data));
    }

    @Test
    public void rejectSignatureAsTooYoung() throws IOException {
        byte[] signature = ((DetachedSign)sop.sign().key(key)).data(data).toByteArrayAndResult().getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> ((DetachedVerify)((DetachedVerify)sop.verify().cert(cert)).notBefore(new Date(System.currentTimeMillis() + 10000L))).signatures(signature).data(data));
    }

    @Test
    public void mode() throws IOException, PGPException {
        byte[] signature = ((DetachedSign)sop.sign().mode(SignAs.text).key(key)).data(data).toByteArrayAndResult().getBytes();
        PGPSignature sig = (PGPSignature)SignatureUtils.readSignatures((byte[])signature).get(0);
        Assertions.assertEquals((int)SignatureType.CANONICAL_TEXT_DOCUMENT.getCode(), (int)sig.getSignatureType());
    }
}

