/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sop.SOP;
import sop.operation.Version;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/sop/VersionImpl;", "Lsop/operation/Version;", "()V", "formatSopJavaVersion", "", "getBackendVersion", "getExtendedVersion", "getName", "getSopSpecImplementationRemarks", "getSopSpecRevisionNumber", "", "getSopVVersion", "getVersion", "isSopSpecImplementationIncomplete", "", "Companion", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nVersionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionImpl.kt\norg/pgpainless/sop/VersionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class VersionImpl
implements Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int SOP_VERSION = 10;
    @NotNull
    public static final String SOPV_VERSION = "1.0";

    @NotNull
    public String getBackendVersion() {
        return "PGPainless " + this.getVersion();
    }

    @NotNull
    public String getExtendedVersion() {
        Locale locale = Locale.US;
        String string = "Bouncy Castle %.2f";
        Object[] objectArray = new Object[]{new BouncyCastleProvider().getVersion()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        String bcVersion = string2;
        string = "%02d";
        objectArray = new Object[]{10};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String specVersion = string3;
        return this.getName() + ' ' + this.getVersion() + "\nhttps://codeberg.org/PGPainless/pgpainless/src/branch/main/pgpainless-sop\n\nImplementation of the Stateless OpenPGP Protocol Version " + specVersion + "\nhttps://datatracker.ietf.org/doc/html/draft-dkg-openpgp-stateless-cli-" + specVersion + "\n\nBased on pgpainless-core " + this.getVersion() + "\nhttps://pgpainless.org\n" + this.formatSopJavaVersion() + "\nUsing " + bcVersion + "\nhttps://www.bouncycastle.org/java.html";
    }

    @NotNull
    public String getName() {
        return "PGPainless-SOP";
    }

    @Nullable
    public String getSopSpecImplementationRemarks() {
        return null;
    }

    public int getSopSpecRevisionNumber() {
        return 10;
    }

    @NotNull
    public String getSopVVersion() {
        return SOPV_VERSION;
    }

    @NotNull
    public String getVersion() {
        String string;
        try {
            Properties properties;
            InputStream inputStream = SOP.class.getResourceAsStream("/pgpainless-sop.properties");
            if (inputStream == null) {
                throw new IOException("File pgpainless-sop.properties not found.");
            }
            InputStream resourceIn = inputStream;
            Properties $this$getVersion_u24lambda_u240 = properties = new Properties();
            boolean bl = false;
            $this$getVersion_u24lambda_u240.load(resourceIn);
            Properties properties2 = properties;
            string = properties2.getProperty("pgpainless-sop-version");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val resour\u2026s-sop-version\")\n        }");
        }
        catch (IOException e) {
            string = "DEVELOPMENT";
        }
        return string;
    }

    private final String formatSopJavaVersion() {
        String string;
        block3: {
            block2: {
                string = this.getSopJavaVersion();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = StringsKt.trimIndent((String)("\n            \n            sop-java " + it + "\n            \n        "));
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    public boolean isSopSpecImplementationIncomplete() {
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/sop/VersionImpl$Companion;", "", "()V", "SOPV_VERSION", "", "SOP_VERSION", "", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

