/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.pgpainless.operation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.util.Passphrase;
import sop.SOP;
import sop.testsuite.operation.ChangeKeyPasswordTest;

public class PGPainlessChangeKeyPasswordTest
extends ChangeKeyPasswordTest {
    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordOfKeyWithSeparateSubkeyPasswords(SOP sop) throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE}))).build();
        Iterator keys = secretKeys.getPublicKeys();
        long primaryKeyId = ((PGPPublicKey)keys.next()).getKeyID();
        long signingKeyId = ((PGPPublicKey)keys.next()).getKeyID();
        long encryptKeyId = ((PGPPublicKey)keys.next()).getKeyID();
        String p1 = "sw0rdf1sh";
        String p2 = "0r4ng3";
        String p3 = "dr4g0n";
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).changeSubKeyPassphraseFromOldPassphrase(primaryKeyId, Passphrase.emptyPassphrase()).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((CharSequence)p1)).changeSubKeyPassphraseFromOldPassphrase(signingKeyId, Passphrase.emptyPassphrase()).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((CharSequence)p2)).changeSubKeyPassphraseFromOldPassphrase(encryptKeyId, Passphrase.emptyPassphrase()).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((CharSequence)p3)).done();
        String p4 = "m0nk3y";
        byte[] keyWithNewPassword = sop.changeKeyPassword().oldKeyPassphrase(p1).oldKeyPassphrase(p2).oldKeyPassphrase(p3).newKeyPassphrase(p4).keys(secretKeys.getEncoded()).getBytes();
        byte[] cert = sop.extractCert().key(keyWithNewPassword).getBytes();
        byte[] signedAndEncrypted = sop.encrypt().signWith(keyWithNewPassword).withKeyPassword(p4).withCert(cert).plaintext("Hello, World!\n".getBytes(StandardCharsets.UTF_8)).toByteArrayAndResult().getBytes();
        byte[] plaintext = sop.decrypt().verifyWithCert(cert).withKey(keyWithNewPassword).withKeyPassword(p4).ciphertext(signedAndEncrypted).toByteArrayAndResult().getBytes();
        Assertions.assertArrayEquals((byte[])"Hello, World!\n".getBytes(StandardCharsets.UTF_8), (byte[])plaintext);
    }
}

