/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.operation.InlineSign;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/sop/InlineSignImpl;", "Lsop/operation/InlineSign;", "()V", "armor", "", "mode", "Lsop/enums/InlineSignAs;", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "signingKeys", "", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "data", "Lsop/Ready;", "Ljava/io/InputStream;", "key", "modeToSigType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "noArmor", "withKeyPassword", "password", "", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nInlineSignImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineSignImpl.kt\norg/pgpainless/sop/InlineSignImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1855#2,2:128\n1855#2,2:130\n1#3:132\n*S KotlinDebug\n*F\n+ 1 InlineSignImpl.kt\norg/pgpainless/sop/InlineSignImpl\n*L\n40#1:128,2\n100#1:130,2\n*E\n"})
public final class InlineSignImpl
implements InlineSign {
    @NotNull
    private final SigningOptions signingOptions = SigningOptions.Companion.get();
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    @NotNull
    private final List<PGPSecretKeyRing> signingKeys = new ArrayList();
    private boolean armor = true;
    @NotNull
    private InlineSignAs mode = InlineSignAs.binary;

    @NotNull
    public Ready data(@NotNull InputStream data2) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$forEach$iv = this.signingKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing key2 = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            try {
                if (this.mode == InlineSignAs.clearsigned) {
                    this.signingOptions.addDetachedSignature((SecretKeyRingProtector)this.protector, key2, this.modeToSigType(this.mode));
                    continue;
                }
                this.signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, key2, this.modeToSigType(this.mode));
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)key2)) + " cannot sign.", (Throwable)e);
            }
            catch (KeyException.MissingSecretKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)key2)) + " does not have the secret signing key component available.", (Throwable)e);
            }
            catch (PGPException e) {
                throw new SOPGPException.KeyIsProtected("Key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)key2)) + " cannot be unlocked.", (Throwable)e);
            }
        }
        ProducerOptions $this$data_u24lambda_u241 = producerOptions = ProducerOptions.Companion.sign(this.signingOptions);
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                $this$data_u24lambda_u241.setCleartextSigned();
                $this$data_u24lambda_u241.setAsciiArmor(true);
                $this$data_u24lambda_u241.setEncoding(StreamEncoding.TEXT);
                $this$data_u24lambda_u241.applyCRLFEncoding();
                break;
            }
            case 2: {
                $this$data_u24lambda_u241.setEncoding(StreamEncoding.TEXT);
                $this$data_u24lambda_u241.applyCRLFEncoding();
                break;
            }
            default: {
                $this$data_u24lambda_u241.setAsciiArmor(this.armor);
            }
        }
        $this$data_u24lambda_u241.overrideCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED);
        ProducerOptions producerOptions2 = producerOptions;
        return new Ready(producerOptions2, data2, this){
            final /* synthetic */ ProducerOptions $producerOptions;
            final /* synthetic */ InputStream $data;
            final /* synthetic */ InlineSignImpl this$0;
            {
                this.$producerOptions = $producerOptions;
                this.$data = $data;
                this.this$0 = $receiver;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                try {
                    EncryptionStream signingStream = PGPainless.Companion.encryptAndOrSign().onOutputStream(outputStream).withOptions(this.$producerOptions);
                    Streams.pipeAll((InputStream)this.$data, (OutputStream)((OutputStream)signingStream));
                    signingStream.close();
                    InlineSignImpl.access$getProtector$p(this.this$0).clear();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @NotNull
    public InlineSign key(@NotNull InputStream key2) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        InlineSignImpl $this$key_u24lambda_u243 = inlineSignImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)KeyReader.Companion.readSecretKeys(key2, true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            KeyRingInfo info = PGPainless.Companion.inspectKeyRing$default((PGPainless.Companion)PGPainless.Companion, (PGPKeyRing)((PGPKeyRing)it), null, (int)2, null);
            if (!info.isUsableForSigning()) {
                throw new SOPGPException.KeyCannotSign("Key " + info.getFingerprint() + " does not have valid, signing capable subkeys.");
            }
            $this$key_u24lambda_u243.protector.addSecretKey(it);
            $this$key_u24lambda_u243.signingKeys.add(it);
        }
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign mode(@NotNull InlineSignAs mode) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        InlineSignImpl $this$mode_u24lambda_u244 = inlineSignImpl = this;
        boolean bl = false;
        $this$mode_u24lambda_u244.mode = mode;
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign noArmor() {
        InlineSignImpl inlineSignImpl;
        InlineSignImpl $this$noArmor_u24lambda_u245 = inlineSignImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u245.armor = false;
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign withKeyPassword(@NotNull byte[] password) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        InlineSignImpl $this$withKeyPassword_u24lambda_u246 = inlineSignImpl = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u246.protector.addPassphrase(Passphrase.Companion.fromPassword((CharSequence)new String(password, UTF8Util.UTF8)));
        return inlineSignImpl;
    }

    private final DocumentSignatureType modeToSigType(InlineSignAs mode) {
        DocumentSignatureType documentSignatureType;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 3: {
                documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
                break;
            }
            case 2: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            case 1: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return documentSignatureType;
    }

    public static final /* synthetic */ MatchMakingSecretKeyRingProtector access$getProtector$p(InlineSignImpl $this) {
        return $this.protector;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlineSignAs.values().length];
            try {
                nArray[InlineSignAs.clearsigned.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineSignAs.text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineSignAs.binary.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

