/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.sop.SOPImpl;
import org.pgpainless.util.Passphrase;
import sop.SOP;
import sop.exception.SOPGPException;

public class GenerateKeyTest {
    private SOP sop;

    @BeforeEach
    public void prepare() {
        this.sop = new SOPImpl();
    }

    @Test
    public void generateKey() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(bytes);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
    }

    @Test
    public void generateKeyWithMultipleUserIds() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").userId("Al <al@example.org>").generate().getBytes();
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(bytes);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)"Alice <alice@pgpainless.org>", (Object)info.getPrimaryUserId());
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Al <al@example.org>"));
    }

    @Test
    public void unarmoredKey() throws IOException {
        byte[] bytes = this.sop.generateKey().userId("Alice <alice@pgpainless.org>").noArmor().generate().getBytes();
        Assertions.assertFalse((boolean)new String(bytes).startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----"));
    }

    @Test
    public void protectedMultiUserIdKey() throws IOException, PGPException {
        byte[] bytes = this.sop.generateKey().userId("Alice").userId("Bob").withKeyPassword("sw0rdf1sh").generate().getBytes();
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(bytes);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        Assertions.assertTrue((boolean)info.getUserIds().contains("Alice"));
        Assertions.assertTrue((boolean)info.getUserIds().contains("Bob"));
        for (PGPSecretKey key : secretKey) {
            Assertions.assertNotNull((Object)UnlockSecretKey.unlockSecretKey((PGPSecretKey)key, (Passphrase)Passphrase.fromPassword((CharSequence)"sw0rdf1sh")));
        }
    }

    @Test
    public void invalidProfile() {
        Assertions.assertThrows(SOPGPException.UnsupportedProfile.class, () -> this.sop.generateKey().profile("invalid"));
    }

    @Test
    public void generateKeyWithNewlinesInUserId() throws IOException {
        byte[] keyBytes = this.sop.generateKey().userId("Foo\n\nBar").generate().getBytes();
        PGPSecretKeyRing key = PGPainless.readKeyRing().secretKeyRing(keyBytes);
        Assertions.assertTrue((boolean)((String)PGPainless.inspectKeyRing((PGPKeyRing)key).getValidUserIds().get(0)).equals("Foo\n\nBar"));
    }
}

