/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.ChangeKeyPassword;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/sop/ChangeKeyPasswordImpl;", "Lsop/operation/ChangeKeyPassword;", "()V", "armor", "", "newPassphrase", "Lorg/pgpainless/util/Passphrase;", "oldProtector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "keys", "Lsop/Ready;", "Ljava/io/InputStream;", "newKeyPassphrase", "", "noArmor", "oldKeyPassphrase", "oldPassphrase", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nChangeKeyPasswordImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeKeyPasswordImpl.kt\norg/pgpainless/sop/ChangeKeyPasswordImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n1#3:87\n*S KotlinDebug\n*F\n+ 1 ChangeKeyPasswordImpl.kt\norg/pgpainless/sop/ChangeKeyPasswordImpl\n*L\n40#1:83\n40#1:84,3\n*E\n"})
public final class ChangeKeyPasswordImpl
implements ChangeKeyPassword {
    @NotNull
    private final MatchMakingSecretKeyRingProtector oldProtector = new MatchMakingSecretKeyRingProtector();
    @NotNull
    private Passphrase newPassphrase = Passphrase.Companion.emptyPassphrase();
    private boolean armor = true;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Ready keys(@NotNull InputStream keys2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection;
        Intrinsics.checkNotNullParameter((Object)keys2, (String)"keys");
        SecretKeyRingProtector newProtector = SecretKeyRingProtector.Companion.unlockAnyKeyWith(this.newPassphrase);
        try {
            pGPSecretKeyRingCollection = KeyReader.Companion.readSecretKeys(keys2, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        PGPSecretKeyRingCollection secretKeysCollection = pGPSecretKeyRingCollection;
        Iterable e = (Iterable)secretKeysCollection;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PGPSecretKeyRing pGPSecretKeyRing;
            void secretKeys;
            PGPSecretKeyRing pGPSecretKeyRing2 = (PGPSecretKeyRing)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secretKeys, (String)"secretKeys");
            this.oldProtector.addSecretKey((PGPSecretKeyRing)secretKeys);
            try {
                pGPSecretKeyRing = KeyRingUtils.Companion.changePassphrase(null, (PGPSecretKeyRing)secretKeys, (SecretKeyRingProtector)this.oldProtector, newProtector);
            }
            catch (MissingPassphraseException e2) {
                throw new SOPGPException.KeyIsProtected("Cannot unlock key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)secretKeys)), (Throwable)e2);
            }
            catch (PGPException e3) {
                String string = e3.getMessage();
                boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Exception decrypting key", (boolean)false, (int)2, null) : false;
                if (bl2) {
                    throw new SOPGPException.KeyIsProtected("Cannot unlock key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)secretKeys)), (Throwable)e3);
                }
                throw new RuntimeException("Cannot change passphrase of key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)secretKeys)), e3);
            }
            collection.add(pGPSecretKeyRing);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        PGPSecretKeyRingCollection updatedSecretKeys = new PGPSecretKeyRingCollection((Collection)it);
        return new Ready(this, updatedSecretKeys){
            final /* synthetic */ ChangeKeyPasswordImpl this$0;
            final /* synthetic */ PGPSecretKeyRingCollection $updatedSecretKeys;
            {
                this.this$0 = $receiver;
                this.$updatedSecretKeys = $updatedSecretKeys;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                if (ChangeKeyPasswordImpl.access$getArmor$p(this.this$0)) {
                    Closeable closeable = (Closeable)ArmoredOutputStreamFactory.Companion.get$default((ArmoredOutputStreamFactory.Companion)ArmoredOutputStreamFactory.Companion, (OutputStream)outputStream, null, (int)2, null);
                    PGPSecretKeyRingCollection pGPSecretKeyRingCollection = this.$updatedSecretKeys;
                    Throwable throwable = null;
                    try {
                        ArmoredOutputStream it = (ArmoredOutputStream)closeable;
                        boolean bl = false;
                        pGPSecretKeyRingCollection.encode((OutputStream)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    this.$updatedSecretKeys.encode(outputStream);
                }
            }
        };
    }

    @NotNull
    public ChangeKeyPassword newKeyPassphrase(@NotNull String newPassphrase) {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        Intrinsics.checkNotNullParameter((Object)newPassphrase, (String)"newPassphrase");
        ChangeKeyPasswordImpl $this$newKeyPassphrase_u24lambda_u242 = changeKeyPasswordImpl = this;
        boolean bl = false;
        $this$newKeyPassphrase_u24lambda_u242.newPassphrase = Passphrase.Companion.fromPassword((CharSequence)newPassphrase);
        return changeKeyPasswordImpl;
    }

    @NotNull
    public ChangeKeyPassword noArmor() {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        ChangeKeyPasswordImpl $this$noArmor_u24lambda_u243 = changeKeyPasswordImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u243.armor = false;
        return changeKeyPasswordImpl;
    }

    @NotNull
    public ChangeKeyPassword oldKeyPassphrase(@NotNull String oldPassphrase) {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        Intrinsics.checkNotNullParameter((Object)oldPassphrase, (String)"oldPassphrase");
        ChangeKeyPasswordImpl $this$oldKeyPassphrase_u24lambda_u244 = changeKeyPasswordImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(oldPassphrase, $this$oldKeyPassphrase_u24lambda_u244.oldProtector);
        return changeKeyPasswordImpl;
    }

    public static final /* synthetic */ boolean access$getArmor$p(ChangeKeyPasswordImpl $this) {
        return $this.armor;
    }
}

